/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.userblocks.UserBlocks;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class UserBlocksEntity
extends BaseManagementEntity {
    UserBlocksEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<UserBlocks> getByIdentifier(String identifier) {
        Asserts.assertNotNull(identifier, "identifier");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addQueryParameter("identifier", identifier).build().toString();
        return new BaseRequest<UserBlocks>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<UserBlocks>(){});
    }

    public Request<Void> deleteByIdentifier(String identifier) {
        Asserts.assertNotNull(identifier, "identifier");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addQueryParameter("identifier", identifier).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<UserBlocks> get(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addPathSegment(userId).build().toString();
        return new BaseRequest<UserBlocks>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<UserBlocks>(){});
    }

    public Request<Void> delete(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addPathSegment(userId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

