/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.rules.RulesConfig;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class RulesConfigsEntity
extends BaseManagementEntity {
    RulesConfigsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<RulesConfig>> list() {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs");
        String url = builder.build().toString();
        return new BaseRequest<List<RulesConfig>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<RulesConfig>>(){});
    }

    public Request<Void> delete(String rulesConfigKey) {
        Asserts.assertNotNull(rulesConfigKey, "rules config key");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs").addPathSegment(rulesConfigKey).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<RulesConfig> update(String rulesConfigKey, RulesConfig rulesConfig) {
        Asserts.assertNotNull(rulesConfigKey, "rules config key");
        Asserts.assertNotNull(rulesConfig, "rules config");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs").addPathSegment(rulesConfigKey).build().toString();
        BaseRequest<RulesConfig> request = new BaseRequest<RulesConfig>(this.client, this.tokenProvider, url, HttpMethod.PUT, new TypeReference<RulesConfig>(){});
        request.setBody(rulesConfig);
        return request;
    }
}

