/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.client.mgmt.filter.InvitationsFilter;
import com.auth0.client.mgmt.filter.OrganizationClientGrantsFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.json.mgmt.organizations.CreateOrganizationClientGrantRequestBody;
import com.auth0.json.mgmt.organizations.EnabledConnection;
import com.auth0.json.mgmt.organizations.EnabledConnectionsPage;
import com.auth0.json.mgmt.organizations.Invitation;
import com.auth0.json.mgmt.organizations.InvitationsPage;
import com.auth0.json.mgmt.organizations.Members;
import com.auth0.json.mgmt.organizations.MembersPage;
import com.auth0.json.mgmt.organizations.Organization;
import com.auth0.json.mgmt.organizations.OrganizationClientGrant;
import com.auth0.json.mgmt.organizations.OrganizationClientGrantsPage;
import com.auth0.json.mgmt.organizations.OrganizationsPage;
import com.auth0.json.mgmt.organizations.Roles;
import com.auth0.json.mgmt.roles.RolesPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class OrganizationsEntity
extends BaseManagementEntity {
    private static final String ORGS_PATH = "api/v2/organizations";

    OrganizationsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<OrganizationsPage> list(PageFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<OrganizationsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<OrganizationsPage>(){});
    }

    public Request<Organization> get(String orgId) {
        Asserts.assertNotNull(orgId, "organization ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        return new BaseRequest<Organization>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Organization>(){});
    }

    public Request<Organization> getByName(String orgName) {
        Asserts.assertNotNull(orgName, "organization name");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment("name").addPathSegment(orgName).build().toString();
        return new BaseRequest<Organization>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Organization>(){});
    }

    public Request<Organization> create(Organization organization) {
        Asserts.assertNotNull(organization, "organization");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).build().toString();
        BaseRequest<Organization> request = new BaseRequest<Organization>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Organization>(){});
        request.setBody(organization);
        return request;
    }

    public Request<Organization> update(String orgId, Organization organization) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(organization, "organization");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        BaseRequest<Organization> request = new BaseRequest<Organization>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Organization>(){});
        request.setBody(organization);
        return request;
    }

    public Request<Void> delete(String orgId) {
        Asserts.assertNotNull(orgId, "organization ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<MembersPage> getMembers(String orgId, PageFilter filter) {
        return this.getMembers(orgId, filter, null);
    }

    public Request<MembersPage> getMembers(String orgId, PageFilter pageFilter, FieldsFilter fieldsFilter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members");
        this.applyFilter(pageFilter, builder);
        this.applyFilter(fieldsFilter, builder);
        String url = builder.build().toString();
        return new BaseRequest<MembersPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<MembersPage>(){});
    }

    public Request<Void> addMembers(String orgId, Members members) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(members, "members");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(members);
        return request;
    }

    public Request<Void> deleteMembers(String orgId, Members members) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(members, "members");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
        request.setBody(members);
        return request;
    }

    public Request<EnabledConnectionsPage> getConnections(String orgId, PageFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<EnabledConnectionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<EnabledConnectionsPage>(){});
    }

    public Request<EnabledConnection> getConnection(String orgId, String connectionId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        return new BaseRequest<EnabledConnection>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<EnabledConnection>(){});
    }

    public Request<EnabledConnection> addConnection(String orgId, EnabledConnection connection) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").build().toString();
        BaseRequest<EnabledConnection> request = new BaseRequest<EnabledConnection>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<EnabledConnection>(){});
        request.setBody(connection);
        return request;
    }

    public Request<Void> deleteConnection(String orgId, String connectionId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<EnabledConnection> updateConnection(String orgId, String connectionId, EnabledConnection connection) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        BaseRequest<EnabledConnection> request = new BaseRequest<EnabledConnection>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<EnabledConnection>(){});
        request.setBody(connection);
        return request;
    }

    public Request<RolesPage> getRoles(String orgId, String userId, PageFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<RolesPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<RolesPage>(){});
    }

    public Request<Void> addRoles(String orgId, String userId, Roles roles) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(roles, "roles");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(roles);
        return request;
    }

    public Request<Void> deleteRoles(String orgId, String userId, Roles roles) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(roles, "roles");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
        request.setBody(roles);
        return request;
    }

    public Request<Invitation> createInvitation(String orgId, Invitation invitation) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitation, "invitation");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").build().toString();
        BaseRequest<Invitation> request = new BaseRequest<Invitation>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Invitation>(){});
        request.setBody(invitation);
        return request;
    }

    public Request<Invitation> getInvitation(String orgId, String invitationId, FieldsFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitationId, "invitation ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").addPathSegment(invitationId);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<Invitation>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Invitation>(){});
    }

    public Request<InvitationsPage> getInvitations(String orgId, InvitationsFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<InvitationsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<InvitationsPage>(){});
    }

    public Request<Void> deleteInvitation(String orgId, String invitationId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitationId, "invitation ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").addPathSegment(invitationId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<OrganizationClientGrantsPage> listClientGrants(String orgId, OrganizationClientGrantsFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegments(orgId).addPathSegment("client-grants");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<OrganizationClientGrantsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<OrganizationClientGrantsPage>(){});
    }

    public Request<OrganizationClientGrant> addClientGrant(String orgId, CreateOrganizationClientGrantRequestBody addOrganizationClientGrantRequestBody) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(addOrganizationClientGrantRequestBody, "client grant");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("client-grants").build().toString();
        BaseRequest<OrganizationClientGrant> request = new BaseRequest<OrganizationClientGrant>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<OrganizationClientGrant>(){});
        request.setBody(addOrganizationClientGrantRequestBody);
        return request;
    }

    public Request<Void> deleteClientGrant(String orgId, String grantId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(grantId, "client grant ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("client-grants").addPathSegment(grantId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    private void applyFilter(BaseFilter filter, HttpUrl.Builder builder) {
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
    }
}

