/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.ConnectionFilter;
import com.auth0.json.mgmt.connections.Connection;
import com.auth0.json.mgmt.connections.ConnectionsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class ConnectionsEntity
extends BaseManagementEntity {
    ConnectionsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<ConnectionsPage> listAll(ConnectionFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/connections");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<ConnectionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ConnectionsPage>(){});
    }

    public Request<Connection> get(String connectionId, ConnectionFilter filter) {
        Asserts.assertNotNull(connectionId, "connection id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<Connection>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Connection>(){});
    }

    public Request<Connection> create(Connection connection) {
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").build().toString();
        BaseRequest<Connection> request = new BaseRequest<Connection>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Connection>(){});
        request.setBody(connection);
        return request;
    }

    public Request<Void> delete(String connectionId) {
        Asserts.assertNotNull(connectionId, "connection id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Connection> update(String connectionId, Connection connection) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).build().toString();
        BaseRequest<Connection> request = new BaseRequest<Connection>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Connection>(){});
        request.setBody(connection);
        return request;
    }

    public Request<Void> deleteUser(String connectionId, String email) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(email, "email");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).addPathSegment("users").addQueryParameter("email", email).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

