/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.auth;

import com.auth0.client.HttpOptions;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import com.auth0.client.auth.ClientAssertionSigner;
import com.auth0.client.auth.LogoutUrlBuilder;
import com.auth0.client.auth.PasswordlessEmailType;
import com.auth0.json.ObjectMapperProvider;
import com.auth0.json.auth.CreatedOobResponse;
import com.auth0.json.auth.CreatedOtpResponse;
import com.auth0.json.auth.MfaAuthenticator;
import com.auth0.json.auth.MfaChallengeResponse;
import com.auth0.json.auth.PasswordlessEmailResponse;
import com.auth0.json.auth.PasswordlessSmsResponse;
import com.auth0.json.auth.PushedAuthorizationResponse;
import com.auth0.json.auth.UserInfo;
import com.auth0.net.BaseRequest;
import com.auth0.net.FormBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.SignUpRequest;
import com.auth0.net.TokenRequest;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.DefaultHttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class AuthAPI {
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_AUDIENCE = "audience";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_CONNECTION = "connection";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_OTP = "otp";
    private static final String KEY_REALM = "realm";
    private static final String KEY_MFA_TOKEN = "mfa_token";
    private static final String KEY_CLIENT_ASSERTION = "client_assertion";
    private static final String KEY_CLIENT_ASSERTION_TYPE = "client_assertion_type";
    private static final String PATH_OAUTH = "oauth";
    private static final String PATH_TOKEN = "token";
    private static final String PATH_DBCONNECTIONS = "dbconnections";
    private static final String PATH_REVOKE = "revoke";
    private static final String PATH_PASSWORDLESS = "passwordless";
    private static final String PATH_START = "start";
    private static final String KEY_ORGANIZATION = "organization";
    private final Auth0HttpClient client;
    private final String clientId;
    private final String clientSecret;
    private final ClientAssertionSigner clientAssertionSigner;
    private final HttpUrl baseUrl;

    @Deprecated
    public AuthAPI(String domain, String clientId, String clientSecret, HttpOptions options) {
        this(domain, clientId, clientSecret, null, AuthAPI.buildNetworkingClient(options));
    }

    @Deprecated
    public AuthAPI(String domain, String clientId, String clientSecret) {
        this(domain, clientId, clientSecret, new HttpOptions());
    }

    public static Builder newBuilder(String domain, String clientId, String clientSecret) {
        return new Builder(domain, clientId).withClientSecret(clientSecret);
    }

    public static Builder newBuilder(String domain, String clientId, ClientAssertionSigner clientAssertionSigner) {
        return new Builder(domain, clientId).withClientAssertionSigner(clientAssertionSigner);
    }

    public static Builder newBuilder(String domain, String clientId) {
        return new Builder(domain, clientId);
    }

    private AuthAPI(String domain, String clientId, String clientSecret, ClientAssertionSigner clientAssertionSigner, Auth0HttpClient httpClient) {
        Asserts.assertNotNull(domain, "domain");
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(httpClient, "Http client");
        this.baseUrl = this.createBaseUrl(domain);
        if (this.baseUrl == null) {
            throw new IllegalArgumentException("The domain had an invalid format and couldn't be parsed as an URL.");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientAssertionSigner = clientAssertionSigner;
        this.client = httpClient;
    }

    private static Auth0HttpClient buildNetworkingClient(HttpOptions options) {
        Asserts.assertNotNull(options, "Http options");
        return DefaultHttpClient.newBuilder().withLogging(options.getLoggingOptions()).withMaxRetries(options.getManagementAPIMaxRetries()).withMaxRequests(options.getMaxRequests()).withMaxRequestsPerHost(options.getMaxRequestsPerHost()).withProxy(options.getProxyOptions()).withConnectTimeout(options.getConnectTimeout()).withReadTimeout(options.getReadTimeout()).build();
    }

    Auth0HttpClient getHttpClient() {
        return this.client;
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    private HttpUrl createBaseUrl(String domain) {
        String url = domain;
        if (!domain.startsWith("https://") && !domain.startsWith("http://")) {
            url = "https://" + domain;
        }
        return HttpUrl.parse(url);
    }

    public AuthorizeUrlBuilder authorizeUrl(String redirectUri) {
        Asserts.assertValidUrl(redirectUri, "redirect uri");
        return AuthorizeUrlBuilder.newInstance(this.baseUrl, this.clientId, redirectUri);
    }

    public String authorizeUrlWithPAR(String requestUri) {
        Asserts.assertNotNull(requestUri, "request uri");
        return this.baseUrl.newBuilder().addPathSegment("authorize").addQueryParameter(KEY_CLIENT_ID, this.clientId).addQueryParameter("request_uri", requestUri).build().toString();
    }

    public String authorizeUrlWithJAR(String request) {
        Asserts.assertNotNull(request, "request");
        return this.baseUrl.newBuilder().addPathSegment("authorize").addQueryParameter(KEY_CLIENT_ID, this.clientId).addQueryParameter("request", request).build().toString();
    }

    public Request<PushedAuthorizationResponse> pushedAuthorizationRequest(String redirectUri, String responseType, Map<String, String> params) {
        return this.pushedAuthorizationRequest(redirectUri, responseType, params, null);
    }

    public Request<PushedAuthorizationResponse> pushedAuthorizationRequest(String redirectUri, String responseType, Map<String, String> params, List<Map<String, Object>> authorizationDetails) {
        Asserts.assertValidUrl(redirectUri, "redirect uri");
        Asserts.assertNotNull(responseType, "response type");
        String url = this.baseUrl.newBuilder().addPathSegments("oauth/par").build().toString();
        FormBodyRequest<PushedAuthorizationResponse> request = new FormBodyRequest<PushedAuthorizationResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<PushedAuthorizationResponse>(){});
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter("redirect_uri", redirectUri);
        request.addParameter("response_type", responseType);
        if (Objects.nonNull(this.clientSecret)) {
            request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        }
        if (params != null) {
            params.forEach(request::addParameter);
        }
        try {
            if (Objects.nonNull(authorizationDetails)) {
                String authDetailsJson = ObjectMapperProvider.getMapper().writeValueAsString(authorizationDetails);
                request.addParameter("authorization_details", authDetailsJson);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("'authorizationDetails' must be a list that can be serialized to JSON", e);
        }
        return request;
    }

    public Request<PushedAuthorizationResponse> pushedAuthorizationRequestWithJAR(String request) {
        return this.pushedAuthorizationRequestWithJAR(request, null);
    }

    public Request<PushedAuthorizationResponse> pushedAuthorizationRequestWithJAR(String request, List<Map<String, Object>> authorizationDetails) {
        Asserts.assertNotNull(request, "request");
        String url = this.baseUrl.newBuilder().addPathSegments("oauth/par").build().toString();
        FormBodyRequest<PushedAuthorizationResponse> req = new FormBodyRequest<PushedAuthorizationResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<PushedAuthorizationResponse>(){});
        req.addParameter(KEY_CLIENT_ID, this.clientId);
        req.addParameter("request", request);
        if (Objects.nonNull(this.clientSecret)) {
            req.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        }
        try {
            if (Objects.nonNull(authorizationDetails)) {
                String authDetailsJson = ObjectMapperProvider.getMapper().writeValueAsString(authorizationDetails);
                req.addParameter("authorization_details", authDetailsJson);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("'authorizationDetails' must be a list that can be serialized to JSON", e);
        }
        return req;
    }

    public LogoutUrlBuilder logoutUrl(String returnToUrl, boolean setClientId) {
        Asserts.assertValidUrl(returnToUrl, "return to url");
        return LogoutUrlBuilder.newInstance(this.baseUrl, this.clientId, returnToUrl, setClientId);
    }

    public Request<UserInfo> userInfo(String accessToken) {
        Asserts.assertNotNull(accessToken, "access token");
        String url = this.baseUrl.newBuilder().addPathSegment("userinfo").build().toString();
        BaseRequest<UserInfo> request = new BaseRequest<UserInfo>(this.client, null, url, HttpMethod.GET, new TypeReference<UserInfo>(){});
        request.addHeader("Authorization", "Bearer " + accessToken);
        return request;
    }

    public Request<Void> resetPassword(String email, String connection) {
        return this.resetPassword(this.clientId, email, connection);
    }

    public Request<Void> resetPassword(String clientId, String email, String connection) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull(connection, KEY_CONNECTION);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_DBCONNECTIONS).addPathSegment("change_password").build().toString();
        VoidRequest request = new VoidRequest(this.client, null, url, HttpMethod.POST);
        request.addParameter(KEY_CLIENT_ID, clientId);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter(KEY_CONNECTION, connection);
        return request;
    }

    @Deprecated
    public SignUpRequest signUp(String email, String username, String password, String connection) {
        return this.signUp(email, username, password != null ? password.toCharArray() : null, connection);
    }

    public SignUpRequest signUp(String email, String username, char[] password, String connection) {
        Asserts.assertNotNull(username, KEY_USERNAME);
        SignUpRequest request = this.signUp(email, password, connection);
        request.addParameter(KEY_USERNAME, username);
        return request;
    }

    @Deprecated
    public SignUpRequest signUp(String email, String password, String connection) {
        return this.signUp(email, password != null ? password.toCharArray() : null, connection);
    }

    public SignUpRequest signUp(String email, char[] password, String connection) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull(password, KEY_PASSWORD);
        Asserts.assertNotNull(connection, KEY_CONNECTION);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_DBCONNECTIONS).addPathSegment("signup").build().toString();
        SignUpRequest request = new SignUpRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter(KEY_PASSWORD, password);
        request.addParameter(KEY_CONNECTION, connection);
        return request;
    }

    @Deprecated
    public TokenRequest login(String emailOrUsername, String password) {
        return this.login(emailOrUsername, password != null ? password.toCharArray() : null);
    }

    public TokenRequest login(String emailOrUsername, char[] password) {
        Asserts.assertNotNull(emailOrUsername, "email or username");
        Asserts.assertNotNull(password, KEY_PASSWORD);
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, KEY_PASSWORD);
        request.addParameter(KEY_USERNAME, emailOrUsername);
        request.addParameter(KEY_PASSWORD, password);
        this.addClientAuthentication(request, true);
        return request;
    }

    @Deprecated
    public TokenRequest login(String emailOrUsername, String password, String realm) {
        return this.login(emailOrUsername, password != null ? password.toCharArray() : null, realm);
    }

    public TokenRequest login(String emailOrUsername, char[] password, String realm) {
        Asserts.assertNotNull(emailOrUsername, "email or username");
        Asserts.assertNotNull(password, KEY_PASSWORD);
        Asserts.assertNotNull(realm, KEY_REALM);
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/password-realm");
        request.addParameter(KEY_USERNAME, emailOrUsername);
        request.addParameter(KEY_PASSWORD, password);
        request.addParameter(KEY_REALM, realm);
        this.addClientAuthentication(request, true);
        return request;
    }

    public TokenRequest exchangePasswordlessOtp(String emailOrPhone, String realm, char[] otp) {
        Asserts.assertNotNull(emailOrPhone, "emailOrPhone");
        Asserts.assertNotNull(realm, KEY_REALM);
        Asserts.assertNotNull(otp, KEY_OTP);
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/passwordless/otp");
        request.addParameter(KEY_USERNAME, emailOrPhone);
        request.addParameter(KEY_REALM, realm);
        request.addParameter(KEY_OTP, otp);
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest requestToken(String audience) {
        return this.requestToken(audience, null);
    }

    public TokenRequest requestToken(String audience, String org) {
        Asserts.assertNotNull(audience, KEY_AUDIENCE);
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "client_credentials");
        request.addParameter(KEY_AUDIENCE, audience);
        if (org != null && !org.trim().isEmpty()) {
            request.addParameter(KEY_ORGANIZATION, org);
        }
        this.addClientAuthentication(request, true);
        return request;
    }

    public Request<Void> revokeToken(String refreshToken) {
        Asserts.assertNotNull(refreshToken, "refresh token");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment(PATH_REVOKE).build().toString();
        VoidRequest request = new VoidRequest(this.client, null, url, HttpMethod.POST);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter("token", refreshToken);
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest renewAuth(String refreshToken) {
        Asserts.assertNotNull(refreshToken, "refresh token");
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, KEY_REFRESH_TOKEN);
        request.addParameter(KEY_REFRESH_TOKEN, refreshToken);
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest exchangeCode(String code, String redirectUri) {
        return this.exchangeCode(code, redirectUri, true);
    }

    public TokenRequest exchangeCodeWithVerifier(String code, String verifier, String redirectUri) {
        Asserts.assertNotNull(code, "code");
        Asserts.assertNotNull(redirectUri, "redirect uri");
        Asserts.assertNotNull(verifier, "verifier");
        TokenRequest request = this.exchangeCode(code, redirectUri, false);
        request.addParameter("code_verifier", verifier);
        return request;
    }

    public BaseRequest<PasswordlessEmailResponse> startPasswordlessEmailFlow(String email, PasswordlessEmailType type) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull((Object)type, "type");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_PASSWORDLESS).addPathSegment(PATH_START).build().toString();
        BaseRequest<PasswordlessEmailResponse> request = new BaseRequest<PasswordlessEmailResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<PasswordlessEmailResponse>(){});
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CONNECTION, KEY_EMAIL);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter("send", type.getType());
        this.addClientAuthentication(request, false);
        return request;
    }

    public BaseRequest<PasswordlessSmsResponse> startPasswordlessSmsFlow(String phoneNumber) {
        Asserts.assertNotNull(phoneNumber, "phoneNumber");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_PASSWORDLESS).addPathSegment(PATH_START).build().toString();
        BaseRequest<PasswordlessSmsResponse> request = new BaseRequest<PasswordlessSmsResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<PasswordlessSmsResponse>(){});
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CONNECTION, "sms");
        request.addParameter("phone_number", phoneNumber);
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest exchangeMfaOtp(String mfaToken, char[] otp) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        Asserts.assertNotNull(otp, KEY_OTP);
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/mfa-otp");
        request.addParameter(KEY_MFA_TOKEN, mfaToken);
        request.addParameter(KEY_OTP, otp);
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest exchangeMfaOob(String mfaToken, char[] oobCode, char[] bindingCode) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        Asserts.assertNotNull(oobCode, "OOB code");
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/mfa-oob");
        request.addParameter(KEY_MFA_TOKEN, mfaToken);
        request.addParameter("oob_code", oobCode);
        if (Objects.nonNull(bindingCode) && bindingCode.length > 0) {
            request.addParameter("binding_code", bindingCode);
        }
        this.addClientAuthentication(request, false);
        return request;
    }

    public TokenRequest exchangeMfaRecoveryCode(String mfaToken, char[] recoveryCode) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        Asserts.assertNotNull(recoveryCode, "recovery code");
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/mfa-recovery-code");
        request.addParameter(KEY_MFA_TOKEN, mfaToken);
        request.addParameter("recovery_code", recoveryCode);
        this.addClientAuthentication(request, false);
        return request;
    }

    public Request<MfaChallengeResponse> mfaChallengeRequest(String mfaToken, String challengeType, String authenticatorId) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        String url = this.baseUrl.newBuilder().addPathSegment("mfa").addPathSegment("challenge").build().toString();
        BaseRequest<MfaChallengeResponse> request = new BaseRequest<MfaChallengeResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<MfaChallengeResponse>(){});
        request.addParameter(KEY_MFA_TOKEN, mfaToken);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        this.addClientAuthentication(request, false);
        if (Objects.nonNull(challengeType)) {
            request.addParameter("challenge_type", challengeType);
        }
        if (Objects.nonNull(authenticatorId)) {
            request.addParameter("authenticator_id", authenticatorId);
        }
        return request;
    }

    public Request<CreatedOtpResponse> addOtpAuthenticator(String mfaToken) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        String url = this.baseUrl.newBuilder().addPathSegment("mfa").addPathSegment("associate").build().toString();
        BaseRequest<CreatedOtpResponse> request = new BaseRequest<CreatedOtpResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<CreatedOtpResponse>(){});
        request.addParameter("authenticator_types", Collections.singletonList(KEY_OTP));
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        this.addClientAuthentication(request, false);
        request.addHeader("Authorization", "Bearer " + mfaToken);
        return request;
    }

    public Request<CreatedOobResponse> addOobAuthenticator(String mfaToken, List<String> oobChannels, String phoneNumber) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        Asserts.assertNotNull(oobChannels, "OOB channels");
        String url = this.baseUrl.newBuilder().addPathSegment("mfa").addPathSegment("associate").build().toString();
        BaseRequest<CreatedOobResponse> request = new BaseRequest<CreatedOobResponse>(this.client, null, url, HttpMethod.POST, new TypeReference<CreatedOobResponse>(){});
        request.addParameter("authenticator_types", Collections.singletonList("oob"));
        request.addParameter("oob_channels", oobChannels);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        if (phoneNumber != null) {
            request.addParameter("phone_number", phoneNumber);
        }
        this.addClientAuthentication(request, false);
        request.addHeader("Authorization", "Bearer " + mfaToken);
        return request;
    }

    public Request<List<MfaAuthenticator>> listAuthenticators(String accessToken) {
        Asserts.assertNotNull(accessToken, "access token");
        String url = this.baseUrl.newBuilder().addPathSegment("mfa").addPathSegment("authenticators").build().toString();
        BaseRequest<List<MfaAuthenticator>> request = new BaseRequest<List<MfaAuthenticator>>(this.client, null, url, HttpMethod.GET, new TypeReference<List<MfaAuthenticator>>(){});
        request.addHeader("Authorization", "Bearer " + accessToken);
        return request;
    }

    public Request<Void> deleteAuthenticator(String accessToken, String authenticatorId) {
        Asserts.assertNotNull(accessToken, "access token");
        Asserts.assertNotNull(authenticatorId, "authenticator id");
        String url = this.baseUrl.newBuilder().addPathSegment("mfa").addPathSegment("authenticators").addPathSegment(authenticatorId).build().toString();
        VoidRequest request = new VoidRequest(this.client, null, url, HttpMethod.DELETE);
        request.addHeader("Authorization", "Bearer " + accessToken);
        return request;
    }

    private TokenRequest exchangeCode(String code, String redirectUri, boolean secretRequired) {
        Asserts.assertNotNull(code, "code");
        Asserts.assertNotNull(redirectUri, "redirect uri");
        TokenRequest request = new TokenRequest(this.client, this.getTokenUrl());
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_GRANT_TYPE, "authorization_code");
        request.addParameter("code", code);
        request.addParameter("redirect_uri", redirectUri);
        this.addClientAuthentication(request, secretRequired);
        return request;
    }

    private String getTokenUrl() {
        return this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
    }

    private void addClientAuthentication(BaseRequest<?> request, boolean required) {
        if (required && this.clientSecret == null && this.clientAssertionSigner == null) {
            throw new IllegalStateException("A client secret or client assertion signing key is required for this operation");
        }
        if (Objects.nonNull(this.clientAssertionSigner)) {
            request.addParameter(KEY_CLIENT_ASSERTION, this.clientAssertionSigner.createSignedClientAssertion(this.clientId, this.baseUrl.toString(), this.clientId));
            request.addParameter(KEY_CLIENT_ASSERTION_TYPE, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        } else if (Objects.nonNull(this.clientSecret)) {
            request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        }
    }

    public static class Builder {
        private final String domain;
        private final String clientId;
        private String clientSecret;
        private ClientAssertionSigner clientAssertionSigner;
        private Auth0HttpClient httpClient;

        public Builder(String domain, String clientId) {
            this.domain = domain;
            this.clientId = clientId;
            this.clientSecret = null;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withClientAssertionSigner(ClientAssertionSigner clientAssertionSigner) {
            this.clientAssertionSigner = clientAssertionSigner;
            return this;
        }

        public Builder withHttpClient(Auth0HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AuthAPI build() {
            return new AuthAPI(this.domain, this.clientId, this.clientSecret, this.clientAssertionSigner, Objects.nonNull(this.httpClient) ? this.httpClient : DefaultHttpClient.newBuilder().build());
        }
    }
}

