/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.hamcrest;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.beans.HasProperty;
import wiremock.org.hamcrest.beans.HasPropertyWithValue;
import wiremock.org.hamcrest.beans.SamePropertyValuesAs;
import wiremock.org.hamcrest.collection.ArrayMatching;
import wiremock.org.hamcrest.collection.IsArray;
import wiremock.org.hamcrest.collection.IsArrayWithSize;
import wiremock.org.hamcrest.collection.IsCollectionWithSize;
import wiremock.org.hamcrest.collection.IsEmptyCollection;
import wiremock.org.hamcrest.collection.IsEmptyIterable;
import wiremock.org.hamcrest.collection.IsIn;
import wiremock.org.hamcrest.collection.IsIterableContainingInAnyOrder;
import wiremock.org.hamcrest.collection.IsIterableContainingInOrder;
import wiremock.org.hamcrest.collection.IsIterableContainingInRelativeOrder;
import wiremock.org.hamcrest.collection.IsIterableWithSize;
import wiremock.org.hamcrest.collection.IsMapContaining;
import wiremock.org.hamcrest.collection.IsMapWithSize;
import wiremock.org.hamcrest.core.AllOf;
import wiremock.org.hamcrest.core.AnyOf;
import wiremock.org.hamcrest.core.CombinableMatcher;
import wiremock.org.hamcrest.core.DescribedAs;
import wiremock.org.hamcrest.core.Every;
import wiremock.org.hamcrest.core.Is;
import wiremock.org.hamcrest.core.IsAnything;
import wiremock.org.hamcrest.core.IsEqual;
import wiremock.org.hamcrest.core.IsInstanceOf;
import wiremock.org.hamcrest.core.IsIterableContaining;
import wiremock.org.hamcrest.core.IsNot;
import wiremock.org.hamcrest.core.IsNull;
import wiremock.org.hamcrest.core.IsSame;
import wiremock.org.hamcrest.core.StringContains;
import wiremock.org.hamcrest.core.StringEndsWith;
import wiremock.org.hamcrest.core.StringRegularExpression;
import wiremock.org.hamcrest.core.StringStartsWith;
import wiremock.org.hamcrest.number.BigDecimalCloseTo;
import wiremock.org.hamcrest.number.IsCloseTo;
import wiremock.org.hamcrest.number.IsNaN;
import wiremock.org.hamcrest.number.OrderingComparison;
import wiremock.org.hamcrest.object.HasToString;
import wiremock.org.hamcrest.object.IsCompatibleType;
import wiremock.org.hamcrest.object.IsEventFrom;
import wiremock.org.hamcrest.text.CharSequenceLength;
import wiremock.org.hamcrest.text.IsBlankString;
import wiremock.org.hamcrest.text.IsEmptyString;
import wiremock.org.hamcrest.text.IsEqualCompressingWhiteSpace;
import wiremock.org.hamcrest.text.IsEqualIgnoringCase;
import wiremock.org.hamcrest.text.MatchesPattern;
import wiremock.org.hamcrest.text.StringContainsInOrder;
import wiremock.org.hamcrest.xml.HasXPath;

public class Matchers {
    public static <T> Matcher<T> allOf(Iterable<Matcher<? super T>> matchers) {
        return AllOf.allOf(matchers);
    }

    @SafeVarargs
    public static <T> Matcher<T> allOf(Matcher<? super T> ... matchers) {
        return AllOf.allOf(matchers);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> first, Matcher<? super T> second) {
        return AllOf.allOf(first, second);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third) {
        return AllOf.allOf(first, second, third);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth) {
        return AllOf.allOf(first, second, third, fourth);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth) {
        return AllOf.allOf(first, second, third, fourth, fifth);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth, Matcher<? super T> sixth) {
        return AllOf.allOf(first, second, third, fourth, fifth, sixth);
    }

    public static <T> AnyOf<T> anyOf(Iterable<Matcher<? super T>> matchers) {
        return AnyOf.anyOf(matchers);
    }

    @SafeVarargs
    public static <T> AnyOf<T> anyOf(Matcher<? super T> ... matchers) {
        return AnyOf.anyOf(matchers);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> first, Matcher<? super T> second) {
        return AnyOf.anyOf(first, second);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third) {
        return AnyOf.anyOf(first, second, third);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth) {
        return AnyOf.anyOf(first, second, third, fourth);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth) {
        return AnyOf.anyOf(first, second, third, fourth, fifth);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth, Matcher<? super T> sixth) {
        return AnyOf.anyOf(first, second, third, fourth, fifth, sixth);
    }

    public static <LHS> CombinableMatcher.CombinableBothMatcher<LHS> both(Matcher<? super LHS> matcher) {
        return CombinableMatcher.both(matcher);
    }

    public static <LHS> CombinableMatcher.CombinableEitherMatcher<LHS> either(Matcher<? super LHS> matcher) {
        return CombinableMatcher.either(matcher);
    }

    public static <T> Matcher<T> describedAs(String description, Matcher<T> matcher, Object ... values2) {
        return DescribedAs.describedAs(description, matcher, values2);
    }

    public static <U> Matcher<Iterable<? extends U>> everyItem(Matcher<U> itemMatcher) {
        return Every.everyItem(itemMatcher);
    }

    public static <T> Matcher<T> is(Matcher<T> matcher) {
        return Is.is(matcher);
    }

    public static <T> Matcher<T> is(T value) {
        return Is.is(value);
    }

    public static <T> Matcher<T> isA(Class<?> type) {
        return Is.isA(type);
    }

    public static Matcher<Object> anything() {
        return IsAnything.anything();
    }

    public static Matcher<Object> anything(String description) {
        return IsAnything.anything(description);
    }

    public static <T> Matcher<Iterable<? super T>> hasItem(Matcher<? super T> itemMatcher) {
        return IsIterableContaining.hasItem(itemMatcher);
    }

    public static <T> Matcher<Iterable<? super T>> hasItem(T item) {
        return IsIterableContaining.hasItem(item);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<T>> hasItems(Matcher<? super T> ... itemMatchers) {
        return IsIterableContaining.hasItems(itemMatchers);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<T>> hasItems(T ... items) {
        return IsIterableContaining.hasItems(items);
    }

    public static <T> Matcher<T> equalTo(T operand) {
        return IsEqual.equalTo(operand);
    }

    public static Matcher<Object> equalToObject(Object operand) {
        return IsEqual.equalToObject(operand);
    }

    public static <T> Matcher<T> any(Class<T> type) {
        return IsInstanceOf.any(type);
    }

    public static <T> Matcher<T> instanceOf(Class<?> type) {
        return IsInstanceOf.instanceOf(type);
    }

    public static <T> Matcher<T> not(Matcher<T> matcher) {
        return IsNot.not(matcher);
    }

    public static <T> Matcher<T> not(T value) {
        return IsNot.not(value);
    }

    public static Matcher<Object> notNullValue() {
        return IsNull.notNullValue();
    }

    public static <T> Matcher<T> notNullValue(Class<T> type) {
        return IsNull.notNullValue(type);
    }

    public static Matcher<Object> nullValue() {
        return IsNull.nullValue();
    }

    public static <T> Matcher<T> nullValue(Class<T> type) {
        return IsNull.nullValue(type);
    }

    public static <T> Matcher<T> sameInstance(T target) {
        return IsSame.sameInstance(target);
    }

    public static <T> Matcher<T> theInstance(T target) {
        return IsSame.theInstance(target);
    }

    public static Matcher<String> containsString(String substring) {
        return StringContains.containsString(substring);
    }

    public static Matcher<String> containsStringIgnoringCase(String substring) {
        return StringContains.containsStringIgnoringCase(substring);
    }

    public static Matcher<String> startsWith(String prefix) {
        return StringStartsWith.startsWith(prefix);
    }

    public static Matcher<String> startsWithIgnoringCase(String prefix) {
        return StringStartsWith.startsWithIgnoringCase(prefix);
    }

    public static Matcher<String> endsWith(String suffix) {
        return StringEndsWith.endsWith(suffix);
    }

    public static Matcher<String> endsWithIgnoringCase(String suffix) {
        return StringEndsWith.endsWithIgnoringCase(suffix);
    }

    public static Matcher<String> matchesRegex(Pattern pattern) {
        return StringRegularExpression.matchesRegex(pattern);
    }

    public static Matcher<String> matchesRegex(String regex) {
        return StringRegularExpression.matchesRegex(Pattern.compile(regex));
    }

    @SafeVarargs
    public static <T> IsArray<T> array(Matcher<? super T> ... elementMatchers) {
        return IsArray.array(elementMatchers);
    }

    public static <T> Matcher<T[]> hasItemInArray(Matcher<? super T> elementMatcher) {
        return ArrayMatching.hasItemInArray(elementMatcher);
    }

    public static <T> Matcher<T[]> hasItemInArray(T element) {
        return ArrayMatching.hasItemInArray(element);
    }

    @SafeVarargs
    public static <E> Matcher<E[]> arrayContaining(E ... items) {
        return ArrayMatching.arrayContaining(items);
    }

    @SafeVarargs
    public static <E> Matcher<E[]> arrayContaining(Matcher<? super E> ... itemMatchers) {
        return ArrayMatching.arrayContaining(itemMatchers);
    }

    public static <E> Matcher<E[]> arrayContaining(List<Matcher<? super E>> itemMatchers) {
        return ArrayMatching.arrayContaining(itemMatchers);
    }

    @SafeVarargs
    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Matcher<? super E> ... itemMatchers) {
        return ArrayMatching.arrayContainingInAnyOrder(itemMatchers);
    }

    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Collection<Matcher<? super E>> itemMatchers) {
        return ArrayMatching.arrayContainingInAnyOrder(itemMatchers);
    }

    @SafeVarargs
    public static <E> Matcher<E[]> arrayContainingInAnyOrder(E ... items) {
        return ArrayMatching.arrayContainingInAnyOrder(items);
    }

    public static <E> Matcher<E[]> arrayWithSize(Matcher<? super Integer> sizeMatcher) {
        return IsArrayWithSize.arrayWithSize(sizeMatcher);
    }

    public static <E> Matcher<E[]> arrayWithSize(int size) {
        return IsArrayWithSize.arrayWithSize(size);
    }

    public static <E> Matcher<E[]> emptyArray() {
        return IsArrayWithSize.emptyArray();
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> aMapWithSize(Matcher<? super Integer> sizeMatcher) {
        return IsMapWithSize.aMapWithSize(sizeMatcher);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> aMapWithSize(int size) {
        return IsMapWithSize.aMapWithSize(size);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> anEmptyMap() {
        return IsMapWithSize.anEmptyMap();
    }

    public static <E> Matcher<Collection<? extends E>> hasSize(Matcher<? super Integer> sizeMatcher) {
        return IsCollectionWithSize.hasSize(sizeMatcher);
    }

    public static <E> Matcher<Collection<? extends E>> hasSize(int size) {
        return IsCollectionWithSize.hasSize(size);
    }

    public static <E> Matcher<Collection<? extends E>> empty() {
        return IsEmptyCollection.empty();
    }

    public static <E> Matcher<Collection<E>> emptyCollectionOf(Class<E> unusedToForceReturnType) {
        return IsEmptyCollection.emptyCollectionOf(unusedToForceReturnType);
    }

    public static <E> Matcher<Iterable<? extends E>> emptyIterable() {
        return IsEmptyIterable.emptyIterable();
    }

    public static <E> Matcher<Iterable<E>> emptyIterableOf(Class<E> unusedToForceReturnType) {
        return IsEmptyIterable.emptyIterableOf(unusedToForceReturnType);
    }

    @SafeVarargs
    public static <E> Matcher<Iterable<? extends E>> contains(E ... items) {
        return IsIterableContainingInOrder.contains(items);
    }

    public static <E> Matcher<Iterable<? extends E>> contains(Matcher<? super E> itemMatcher) {
        return IsIterableContainingInOrder.contains(itemMatcher);
    }

    @SafeVarargs
    public static <E> Matcher<Iterable<? extends E>> contains(Matcher<? super E> ... itemMatchers) {
        return IsIterableContainingInOrder.contains(itemMatchers);
    }

    public static <E> Matcher<Iterable<? extends E>> contains(List<Matcher<? super E>> itemMatchers) {
        return IsIterableContainingInOrder.contains(itemMatchers);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(Matcher<? super T> ... itemMatchers) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(T ... items) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(items);
    }

    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(Collection<Matcher<? super T>> itemMatchers) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers);
    }

    @SafeVarargs
    public static <E> Matcher<Iterable<? extends E>> containsInRelativeOrder(E ... items) {
        return IsIterableContainingInRelativeOrder.containsInRelativeOrder(items);
    }

    @SafeVarargs
    public static <E> Matcher<Iterable<? extends E>> containsInRelativeOrder(Matcher<? super E> ... itemMatchers) {
        return IsIterableContainingInRelativeOrder.containsInRelativeOrder(itemMatchers);
    }

    public static <E> Matcher<Iterable<? extends E>> containsInRelativeOrder(List<Matcher<? super E>> itemMatchers) {
        return IsIterableContainingInRelativeOrder.containsInRelativeOrder(itemMatchers);
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(Matcher<? super Integer> sizeMatcher) {
        return IsIterableWithSize.iterableWithSize(sizeMatcher);
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(int size) {
        return IsIterableWithSize.iterableWithSize(size);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> hasEntry(Matcher<? super K> keyMatcher, Matcher<? super V> valueMatcher) {
        return IsMapContaining.hasEntry(keyMatcher, valueMatcher);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> hasEntry(K key, V value) {
        return IsMapContaining.hasEntry(key, value);
    }

    public static <K> Matcher<Map<? extends K, ?>> hasKey(Matcher<? super K> keyMatcher) {
        return IsMapContaining.hasKey(keyMatcher);
    }

    public static <K> Matcher<Map<? extends K, ?>> hasKey(K key) {
        return IsMapContaining.hasKey(key);
    }

    public static <V> Matcher<Map<?, ? extends V>> hasValue(Matcher<? super V> valueMatcher) {
        return IsMapContaining.hasValue(valueMatcher);
    }

    public static <V> Matcher<Map<?, ? extends V>> hasValue(V value) {
        return IsMapContaining.hasValue(value);
    }

    public static <T> Matcher<T> in(Collection<T> collection) {
        return IsIn.in(collection);
    }

    public static <T> Matcher<T> in(T[] elements) {
        return IsIn.in(elements);
    }

    public static <T> Matcher<T> isIn(Collection<T> collection) {
        return IsIn.isIn(collection);
    }

    public static <T> Matcher<T> isIn(T[] elements) {
        return IsIn.isIn(elements);
    }

    @SafeVarargs
    public static <T> Matcher<T> isOneOf(T ... elements) {
        return IsIn.isOneOf(elements);
    }

    @SafeVarargs
    public static <T> Matcher<T> oneOf(T ... elements) {
        return IsIn.oneOf(elements);
    }

    public static Matcher<Double> closeTo(double operand, double error) {
        return IsCloseTo.closeTo(operand, error);
    }

    public static Matcher<Double> notANumber() {
        return IsNaN.notANumber();
    }

    public static Matcher<BigDecimal> closeTo(BigDecimal operand, BigDecimal error) {
        return BigDecimalCloseTo.closeTo(operand, error);
    }

    public static <T extends Comparable<T>> Matcher<T> comparesEqualTo(T value) {
        return OrderingComparison.comparesEqualTo(value);
    }

    public static <T extends Comparable<T>> Matcher<T> greaterThan(T value) {
        return OrderingComparison.greaterThan(value);
    }

    public static <T extends Comparable<T>> Matcher<T> greaterThanOrEqualTo(T value) {
        return OrderingComparison.greaterThanOrEqualTo(value);
    }

    public static <T extends Comparable<T>> Matcher<T> lessThan(T value) {
        return OrderingComparison.lessThan(value);
    }

    public static <T extends Comparable<T>> Matcher<T> lessThanOrEqualTo(T value) {
        return OrderingComparison.lessThanOrEqualTo(value);
    }

    public static Matcher<String> equalToIgnoringCase(String expectedString) {
        return IsEqualIgnoringCase.equalToIgnoringCase(expectedString);
    }

    public static Matcher<String> equalToIgnoringWhiteSpace(String expectedString) {
        return Matchers.equalToCompressingWhiteSpace(expectedString);
    }

    public static Matcher<String> equalToCompressingWhiteSpace(String expectedString) {
        return IsEqualCompressingWhiteSpace.equalToCompressingWhiteSpace(expectedString);
    }

    public static Matcher<String> emptyOrNullString() {
        return IsEmptyString.emptyOrNullString();
    }

    public static Matcher<String> emptyString() {
        return IsEmptyString.emptyString();
    }

    public static Matcher<String> isEmptyOrNullString() {
        return IsEmptyString.isEmptyOrNullString();
    }

    public static Matcher<String> isEmptyString() {
        return IsEmptyString.isEmptyString();
    }

    public static Matcher<String> blankOrNullString() {
        return IsBlankString.blankOrNullString();
    }

    public static Matcher<String> blankString() {
        return IsBlankString.blankString();
    }

    public static Matcher<String> matchesPattern(Pattern pattern) {
        return MatchesPattern.matchesPattern(pattern);
    }

    public static Matcher<String> matchesPattern(String regex) {
        return MatchesPattern.matchesPattern(regex);
    }

    public static Matcher<String> stringContainsInOrder(Iterable<String> substrings) {
        return StringContainsInOrder.stringContainsInOrder(substrings);
    }

    public static Matcher<String> stringContainsInOrder(String ... substrings) {
        return StringContainsInOrder.stringContainsInOrder(substrings);
    }

    public static Matcher<CharSequence> hasLength(int length) {
        return CharSequenceLength.hasLength(length);
    }

    public static <T> Matcher<T> hasToString(Matcher<? super String> toStringMatcher) {
        return HasToString.hasToString(toStringMatcher);
    }

    public static <T> Matcher<T> hasToString(String expectedToString) {
        return HasToString.hasToString(expectedToString);
    }

    public static <T> Matcher<Class<?>> typeCompatibleWith(Class<T> baseType) {
        return IsCompatibleType.typeCompatibleWith(baseType);
    }

    public static Matcher<EventObject> eventFrom(Class<? extends EventObject> eventClass, Object source2) {
        return IsEventFrom.eventFrom(eventClass, source2);
    }

    public static Matcher<EventObject> eventFrom(Object source2) {
        return IsEventFrom.eventFrom(source2);
    }

    public static <T> Matcher<T> hasProperty(String propertyName) {
        return HasProperty.hasProperty(propertyName);
    }

    public static <T> Matcher<T> hasProperty(String propertyName, Matcher<?> valueMatcher) {
        return HasPropertyWithValue.hasProperty(propertyName, valueMatcher);
    }

    public static <B> Matcher<B> samePropertyValuesAs(B expectedBean, String ... ignoredProperties) {
        return SamePropertyValuesAs.samePropertyValuesAs(expectedBean, ignoredProperties);
    }

    public static Matcher<Node> hasXPath(String xPath, Matcher<String> valueMatcher) {
        return HasXPath.hasXPath(xPath, valueMatcher);
    }

    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext, Matcher<String> valueMatcher) {
        return HasXPath.hasXPath(xPath, namespaceContext, valueMatcher);
    }

    public static Matcher<Node> hasXPath(String xPath) {
        return HasXPath.hasXPath(xPath);
    }

    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext) {
        return HasXPath.hasXPath(xPath, namespaceContext);
    }
}

