/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.util.Map;
import wiremock.org.eclipse.jetty.client.ConnectionPool;
import wiremock.org.eclipse.jetty.client.HttpClient;
import wiremock.org.eclipse.jetty.client.HttpClientTransport;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.component.ContainerLifeCycle;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@ManagedObject
public abstract class AbstractHttpClientTransport
extends ContainerLifeCycle
implements HttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private HttpClient client;
    private ConnectionPool.Factory factory;

    protected HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public ConnectionPool.Factory getConnectionPoolFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionPoolFactory(ConnectionPool.Factory factory2) {
        this.factory = factory2;
    }

    protected void connectFailed(Map<String, Object> context, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get("wiremock.org.eclipse.jetty.client.destination"));
        }
        Promise promise = (Promise)context.get("wiremock.org.eclipse.jetty.client.connection.promise");
        promise.failed(failure);
    }
}

