/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.util;

public class IntegerBuffer {
    private static final int INITIAL_SIZE = 512;
    private int[] buffer;
    private int currentSize;

    public IntegerBuffer() {
        this(512);
    }

    public IntegerBuffer(int capacity) {
        this.buffer = new int[capacity];
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public void append(int i) {
        while (this.currentSize >= this.buffer.length) {
            this.grow();
        }
        this.buffer[this.currentSize++] = i;
    }

    public void append(int[] i) {
        while (this.currentSize + i.length > this.buffer.length) {
            this.grow();
        }
        System.arraycopy(i, 0, this.buffer, this.currentSize, i.length);
        this.currentSize += i.length;
    }

    public int[] toIntArray() {
        int[] i = new int[this.currentSize];
        System.arraycopy(this.buffer, 0, i, 0, this.currentSize);
        return i;
    }

    public int indexOf(int[] sequence2) {
        int index = -1;
        for (int i = 0; index == -1 && i <= this.currentSize - sequence2.length; ++i) {
            if (this.buffer[i] != sequence2[0]) continue;
            boolean matches = true;
            for (int j = 1; matches && j < sequence2.length; ++j) {
                if (this.buffer[i + j] == sequence2[j]) continue;
                matches = false;
            }
            if (!matches) continue;
            index = i;
        }
        return index;
    }

    private void grow() {
        int[] i = new int[this.buffer.length * 2 + 1];
        System.arraycopy(this.buffer, 0, i, 0, this.buffer.length);
        this.buffer = i;
    }
}

