/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.output;

import java.util.Objects;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import wiremock.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.serialization.JsonMapperFactory;

public class OutputUnitKey {
    @JsonSerialize(using=ToStringSerializer.class)
    final JsonNodePath evaluationPath;
    @JsonSerialize(using=ToStringSerializer.class)
    final SchemaLocation schemaLocation;
    @JsonSerialize(using=ToStringSerializer.class)
    final JsonNodePath instanceLocation;

    public OutputUnitKey(JsonNodePath evaluationPath, SchemaLocation schemaLocation, JsonNodePath instanceLocation) {
        this.evaluationPath = evaluationPath;
        this.schemaLocation = schemaLocation;
        this.instanceLocation = instanceLocation;
    }

    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public JsonNodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public int hashCode() {
        return Objects.hash(this.evaluationPath, this.instanceLocation, this.schemaLocation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputUnitKey other = (OutputUnitKey)obj;
        return Objects.equals(this.evaluationPath, other.evaluationPath) && Objects.equals(this.instanceLocation, other.instanceLocation) && Objects.equals(this.schemaLocation, other.schemaLocation);
    }

    public String toString() {
        try {
            return JsonMapperFactory.getInstance().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            return "OutputUnitKey [evaluationPath=" + this.evaluationPath + ", schemaLocation=" + this.schemaLocation + ", instanceLocation=" + this.instanceLocation + "]";
        }
    }
}

