/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.ExecutionConfig;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.ExecutionContextCustomizer;
import wiremock.com.networknt.schema.FailFastAssertionException;
import wiremock.com.networknt.schema.InputFormat;
import wiremock.com.networknt.schema.InvalidSchemaException;
import wiremock.com.networknt.schema.InvalidSchemaRefException;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaIdValidator;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.OutputFormat;
import wiremock.com.networknt.schema.PathType;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.SchemaValidatorsConfig;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.TypeValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidationResult;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.serialization.JsonMapperFactory;
import wiremock.com.networknt.schema.serialization.YamlMapperFactory;
import wiremock.com.networknt.schema.utils.JsonNodes;
import wiremock.com.networknt.schema.utils.SetView;

public class JsonSchema
extends BaseJsonValidator {
    private static final long V201909_VALUE = SpecVersion.VersionFlag.V201909.getVersionFlagValue();
    private List<JsonValidator> validators;
    private boolean validatorsLoaded = false;
    private boolean recursiveAnchor = false;
    private JsonValidator requiredValidator = null;
    private TypeValidator typeValidator;
    private final String id;
    private static Comparator<JsonValidator> VALIDATOR_SORT = (lhs, rhs) -> {
        String rhsName;
        String lhsName = lhs.getEvaluationPath().getName(-1);
        if (lhsName.equals(rhsName = rhs.getEvaluationPath().getName(-1))) {
            return 0;
        }
        if (lhsName.equals("properties")) {
            return -1;
        }
        if (rhsName.equals("properties")) {
            return 1;
        }
        if (lhsName.equals("patternProperties")) {
            return -1;
        }
        if (rhsName.equals("patternProperties")) {
            return 1;
        }
        if (lhsName.equals("unevaluatedItems")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedItems")) {
            return -1;
        }
        if (lhsName.equals("unevaluatedProperties")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedProperties")) {
            return -1;
        }
        return 0;
    };

    static JsonSchema from(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaLocation, evaluationPath, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    private boolean hasNoFragment(SchemaLocation schemaLocation) {
        return this.schemaLocation.getFragment() == null || this.schemaLocation.getFragment().getNameCount() == 0;
    }

    private static SchemaLocation resolve(SchemaLocation schemaLocation, JsonNode schemaNode, boolean rootSchema, ValidationContext validationContext) {
        String id = validationContext.resolveSchemaId(schemaNode);
        if (id != null) {
            String resolve = id;
            int fragment = id.indexOf(35);
            if (fragment != -1 && fragment + 1 < id.length()) {
                resolve = id.substring(0, fragment);
            }
            SchemaLocation result = !"".equals(resolve) ? schemaLocation.resolve(resolve) : schemaLocation;
            JsonSchemaIdValidator validator = validationContext.getConfig().getSchemaIdValidator();
            if (validator != null && !validator.validate(id, rootSchema, schemaLocation, result, validationContext)) {
                SchemaLocation idSchemaLocation = schemaLocation.append(validationContext.getMetaSchema().getIdKeyword());
                ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().code(ValidatorTypeCode.ID.getValue())).type(ValidatorTypeCode.ID.getValue())).instanceLocation(idSchemaLocation.getFragment())).arguments(id, validationContext.getMetaSchema().getIdKeyword(), idSchemaLocation)).schemaLocation(idSchemaLocation)).schemaNode(schemaNode)).messageFormatter(args2 -> validationContext.getConfig().getMessageSource().getMessage(ValidatorTypeCode.ID.getValue(), validationContext.getConfig().getLocale(), args2))).build();
                throw new InvalidSchemaException(validationMessage);
            }
            return result;
        }
        return schemaLocation;
    }

    private JsonSchema(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(JsonSchema.resolve(schemaLocation, schemaNode, parent == null, validationContext), evaluationPath, schemaNode, parent, null, null, validationContext, suppressSubSchemaRetrieval);
        String dynamicAnchor;
        String id = this.validationContext.resolveSchemaId(this.schemaNode);
        if (id != null) {
            SchemaLocation result = id.contains("#") ? schemaLocation.resolve(id) : this.schemaLocation;
            this.id = this.hasNoFragment(result) ? id : null;
            this.validationContext.getSchemaResources().putIfAbsent(result != null ? result.toString() : id, this);
        } else if (this.hasNoFragment(schemaLocation)) {
            this.id = schemaLocation.getAbsoluteIri() != null ? schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(schemaLocation != null ? schemaLocation.toString() : this.id, this);
        } else {
            this.id = null;
        }
        String anchor = this.validationContext.getMetaSchema().readAnchor(this.schemaNode);
        if (anchor != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(absoluteIri + "#" + anchor, this);
        }
        if ((dynamicAnchor = this.validationContext.getMetaSchema().readDynamicAnchor(schemaNode)) != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getDynamicAnchors().putIfAbsent(absoluteIri + "#" + dynamicAnchor, this);
        }
        this.getValidators();
    }

    protected JsonSchema(JsonSchema copy) {
        super(copy);
        this.validators = copy.validators;
        this.validatorsLoaded = copy.validatorsLoaded;
        this.recursiveAnchor = copy.recursiveAnchor;
        this.requiredValidator = copy.requiredValidator;
        this.typeValidator = copy.typeValidator;
        this.id = copy.id;
    }

    public JsonSchema fromRef(JsonSchema refEvaluationParentSchema, JsonNodePath refEvaluationPath) {
        JsonSchema copy = new JsonSchema(this);
        copy.validationContext = new ValidationContext(copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), refEvaluationParentSchema.validationContext.getConfig(), refEvaluationParentSchema.getValidationContext().getSchemaReferences(), refEvaluationParentSchema.getValidationContext().getSchemaResources(), refEvaluationParentSchema.getValidationContext().getDynamicAnchors());
        copy.evaluationPath = refEvaluationPath;
        copy.evaluationParentSchema = refEvaluationParentSchema;
        copy.validatorsLoaded = false;
        copy.requiredValidator = null;
        copy.typeValidator = null;
        copy.validators = null;
        return copy;
    }

    public JsonSchema withConfig(SchemaValidatorsConfig config) {
        if (!this.getValidationContext().getConfig().equals(config)) {
            JsonSchema copy = new JsonSchema(this);
            copy.validationContext = new ValidationContext(copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), config, copy.getValidationContext().getSchemaReferences(), copy.getValidationContext().getSchemaResources(), copy.getValidationContext().getDynamicAnchors());
            copy.validatorsLoaded = false;
            copy.requiredValidator = null;
            copy.typeValidator = null;
            copy.validators = null;
            return copy;
        }
        return this;
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findSchemaResourceRoot();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (schema.getId() != null && ref.startsWith(schema.getId())) {
            String refValue;
            jsonPointer = refValue = ref.substring(schema.getId().length());
        }
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = jsonPointer.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        }
        return node;
    }

    public JsonSchema getRefSchema(JsonNodePath fragment) {
        if (PathType.JSON_POINTER.equals((Object)fragment.getPathType())) {
            return this.getSubSchema(fragment);
        }
        String base = this.getSchemaLocation().getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
        String anchor = base + "#" + fragment.toString();
        JsonSchema result = (JsonSchema)this.validationContext.getSchemaResources().get(anchor);
        if (result == null) {
            result = (JsonSchema)this.validationContext.getDynamicAnchors().get(anchor);
        }
        if (result == null) {
            throw new JsonSchemaException("Unable to find anchor " + anchor);
        }
        return result;
    }

    public JsonSchema getSubSchema(JsonNodePath fragment) {
        JsonSchema document;
        JsonSchema parent = document = this.findSchemaResourceRoot();
        JsonSchema subSchema = null;
        JsonNode parentNode = parent.getSchemaNode();
        SchemaLocation schemaLocation = document.getSchemaLocation();
        JsonNodePath evaluationPath = document.getEvaluationPath();
        int nameCount = fragment.getNameCount();
        for (int x = 0; x < nameCount; ++x) {
            Object segment = fragment.getElement(x);
            JsonNode subSchemaNode = this.getNode(parentNode, segment);
            if (subSchemaNode != null) {
                if (segment instanceof Number) {
                    int index = ((Number)segment).intValue();
                    schemaLocation = schemaLocation.append(index);
                    evaluationPath = evaluationPath.append(index);
                } else {
                    schemaLocation = schemaLocation.append(segment.toString());
                    evaluationPath = evaluationPath.append(segment.toString());
                }
                String id = parent.getValidationContext().resolveSchemaId(subSchemaNode);
                if (id != null || x == nameCount - 1) {
                    parent = subSchema = parent.getValidationContext().newSchema(schemaLocation, evaluationPath, subSchemaNode, parent);
                    schemaLocation = subSchema.getSchemaLocation();
                }
            } else {
                JsonSchema found = document.findSchemaResourceRoot().fetchSubSchemaNode(this.validationContext);
                if (found != null) {
                    found = found.getSubSchema(fragment);
                }
                if (found == null) {
                    ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(schemaLocation.getFragment())).schemaLocation(schemaLocation)).evaluationPath(evaluationPath)).arguments(fragment)).build();
                    throw new InvalidSchemaRefException(validationMessage);
                }
                return found;
            }
            parentNode = subSchemaNode;
        }
        return subSchema;
    }

    protected JsonNode getNode(Object propertyOrIndex) {
        return this.getNode(this.schemaNode, propertyOrIndex);
    }

    protected JsonNode getNode(JsonNode node, Object propertyOrIndex) {
        return JsonNodes.get(node, propertyOrIndex);
    }

    public JsonSchema findLexicalRoot() {
        JsonSchema ancestor = this;
        while (ancestor.getId() == null && null != ancestor.getParentSchema()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public JsonSchema findSchemaResourceRoot() {
        JsonSchema ancestor = this;
        while (!ancestor.isSchemaResourceRoot()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public boolean isSchemaResourceRoot() {
        if (this.getId() != null) {
            return true;
        }
        if (this.getParentSchema() == null) {
            return true;
        }
        return !Objects.equals(this.getSchemaLocation().getAbsoluteIri(), this.getParentSchema().getSchemaLocation().getAbsoluteIri());
    }

    public String getId() {
        return this.id;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private List<JsonValidator> read(JsonNode schemaNode) {
        ArrayList<JsonValidator> validators = new ArrayList<JsonValidator>();
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                JsonNodePath path = this.getEvaluationPath().append("true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("true"), path, "true", schemaNode, this);
                validators.add(validator);
            } else {
                JsonNodePath path = this.getEvaluationPath().append("false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("false"), path, "false", schemaNode, this);
                validators.add(validator);
            }
        } else {
            JsonValidator refValidator = null;
            Iterator<Map.Entry<String, JsonNode>> iterator2 = schemaNode.fields();
            while (iterator2.hasNext()) {
                JsonValidator validator;
                Map.Entry<String, JsonNode> entry = iterator2.next();
                String pname = entry.getKey();
                JsonNode nodeToUse = entry.getValue();
                JsonNodePath path = this.getEvaluationPath().append(pname);
                SchemaLocation schemaPath = this.getSchemaLocation().append(pname);
                if ("$recursiveAnchor".equals(pname)) {
                    if (!nodeToUse.isBoolean()) {
                        ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type("$recursiveAnchor")).code("internal.invalidRecursiveAnchor")).message("{0}: The value of a $recursiveAnchor must be a Boolean literal but is {1}")).instanceLocation(path)).evaluationPath(path)).schemaLocation(schemaPath)).arguments(nodeToUse.getNodeType().toString())).build();
                        throw new JsonSchemaException(validationMessage);
                    }
                    this.recursiveAnchor = nodeToUse.booleanValue();
                }
                if ((validator = this.validationContext.newValidator(schemaPath, path, pname, nodeToUse, this)) == null) continue;
                validators.add(validator);
                if ("$ref".equals(pname)) {
                    refValidator = validator;
                    continue;
                }
                if ("required".equals(pname)) {
                    this.requiredValidator = validator;
                    continue;
                }
                if (!"type".equals(pname)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
            if (null != refValidator && this.activeDialect() < V201909_VALUE) {
                validators.clear();
                validators.add(refValidator);
            }
        }
        if (validators.size() > 1) {
            Collections.sort(validators, VALIDATOR_SORT);
        }
        return validators;
    }

    private long activeDialect() {
        return this.validationContext.activeDialect().map(SpecVersion.VersionFlag::getVersionFlagValue).orElse(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        ObjectNode discriminator2;
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator2 = (ObjectNode)this.schemaNode.get("discriminator")) && null != executionContext.getCurrentDiscriminatorContext()) {
            executionContext.getCurrentDiscriminatorContext().registerDiscriminator(this.schemaLocation, discriminator2);
        }
        SetView<ValidationMessage> errors = null;
        JsonSchema.setValidatorState(executionContext, false, true);
        for (JsonValidator v : this.getValidators()) {
            Set<ValidationMessage> results = null;
            try {
                results = v.validate(executionContext, jsonNode, rootNode, instanceLocation);
                if (results == null || results.isEmpty()) continue;
                if (errors == null) {
                    errors = new SetView();
                }
                errors.union(results);
            }
            catch (Throwable throwable) {
                if (results != null && !results.isEmpty()) {
                    if (errors == null) {
                        errors = new SetView<ValidationMessage>();
                    }
                    errors.union(results);
                }
                throw throwable;
            }
        }
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = executionContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaLocation);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaLocation, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        if (errors != null && !errors.isEmpty()) {
            executionContext.getResults().setResult(instanceLocation, this.getSchemaLocation(), this.getEvaluationPath(), false);
        }
        return errors == null ? Collections.emptySet() : errors;
    }

    public Set<ValidationMessage> validate(JsonNode rootNode) {
        return this.validate(rootNode, OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format) {
        return this.validate(rootNode, format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format) {
        return this.validate(executionContext, node, format, null);
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        format.customize(executionContext, this.validationContext);
        if (executionCustomizer != null) {
            executionCustomizer.customize(executionContext, this.validationContext);
        }
        Set<ValidationMessage> validationMessages = null;
        try {
            validationMessages = this.validate(executionContext, node);
        }
        catch (FailFastAssertionException e) {
            validationMessages = e.getValidationMessages();
        }
        return format.format(this, validationMessages, executionContext, this.validationContext);
    }

    private JsonNode deserialize(String input, InputFormat inputFormat) {
        try {
            if (InputFormat.JSON.equals((Object)inputFormat)) {
                return JsonMapperFactory.getInstance().readTree(input);
            }
            if (InputFormat.YAML.equals((Object)inputFormat)) {
                return YamlMapperFactory.getInstance().readTree(input);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid input", e);
        }
        throw new IllegalArgumentException("Unsupported input format " + (Object)((Object)inputFormat));
    }

    public ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode node) {
        return this.validateAndCollect(executionContext, node, node, this.atRoot());
    }

    private ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        JsonSchema.setValidatorState(executionContext, false, true);
        Set<ValidationMessage> errors = this.validate(executionContext, jsonNode, rootNode, instanceLocation);
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        if (config.doLoadCollectors()) {
            CollectorContext collectorContext = executionContext.getCollectorContext();
            collectorContext.loadCollectors();
        }
        return new ValidationResult(errors, executionContext);
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(this.createExecutionContext(), node, node, this.atRoot());
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate);
    }

    public ValidationResult walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate);
    }

    public ValidationResult walk(JsonNode node, boolean validate) {
        return this.walk(this.createExecutionContext(), node, validate);
    }

    public ValidationResult walk(String input, InputFormat inputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate);
    }

    public ValidationResult walkAtNode(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate);
    }

    private ValidationResult walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        JsonSchema.setValidatorState(executionContext, true, shouldValidateSchema);
        Set<ValidationMessage> errors = this.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        if (config.doLoadCollectors()) {
            CollectorContext collectorContext = executionContext.getCollectorContext();
            collectorContext.loadCollectors();
        }
        return new ValidationResult(errors, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonValidator validator : this.getValidators()) {
            JsonNodePath evaluationPathWithKeyword = validator.getEvaluationPath();
            try {
                if (!this.validationContext.getConfig().getKeywordWalkListenerRunner().runPreWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, this, validator)) continue;
                Set<ValidationMessage> results = null;
                try {
                    results = validator.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    if (results == null || results.isEmpty()) continue;
                    errors.addAll(results);
                }
            }
            finally {
                this.validationContext.getConfig().getKeywordWalkListenerRunner().runPostWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, this, validator, errors);
            }
        }
        return errors;
    }

    private static void setValidatorState(ExecutionContext executionContext, boolean isWalkEnabled, boolean shouldValidateSchema) {
        ValidatorState validatorState = executionContext.getValidatorState();
        if (validatorState == null) {
            executionContext.setValidatorState(new ValidatorState(isWalkEnabled, shouldValidateSchema));
        }
    }

    @Override
    public String toString() {
        return "\"" + this.getEvaluationPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public boolean hasTypeValidator() {
        return this.getTypeValidator() != null;
    }

    public TypeValidator getTypeValidator() {
        if (this.validators == null) {
            this.getValidators();
        }
        return this.typeValidator;
    }

    public List<JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableList(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            for (JsonValidator validator : this.getValidators()) {
                validator.preloadJsonSchema();
            }
            this.validatorsLoaded = true;
        }
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public ExecutionContext createExecutionContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLocale(config.getLocale());
        executionConfig.setFormatAssertionsEnabled(config.getFormatAssertionsEnabled());
        executionConfig.setFailFast(config.isFailFast());
        ExecutionContext executionContext = new ExecutionContext(executionConfig);
        if (config.getExecutionContextCustomizer() != null) {
            config.getExecutionContextCustomizer().customize(executionContext, this.validationContext);
        }
        return executionContext;
    }
}

