/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;

public final class Files {
    private Files() {
    }

    public static String read(String location, Charset charset) throws IOException {
        return Files.read(Files.class.getResourceAsStream(location), charset);
    }

    public static String read(File source2, Charset charset) throws IOException {
        return Files.read(new FileInputStream(source2), charset);
    }

    public static String read(InputStream source2, Charset charset) throws IOException {
        return Files.read(new InputStreamReader(source2, charset));
    }

    public static String read(Reader source2) throws IOException {
        return Files.read(new BufferedReader(source2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(BufferedReader source2) throws IOException {
        Validate.notNull(source2, "The input is required.", new Object[0]);
        try {
            int ch = source2.read();
            StringBuilder script = new StringBuilder();
            while (ch != -1) {
                script.append((char)ch);
                ch = source2.read();
            }
            String string = script.toString();
            return string;
        }
        finally {
            source2.close();
        }
    }
}

