/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.org.apache.commons.codec.binary.Base64;

public class Rsa256JsonWebKey {
    public final String alg;
    public final String kty;
    public final String use;
    public final List<String> x5c;
    public final String n;
    public final String e;
    public final String kid;
    public final String x5t;

    public Rsa256JsonWebKey(@JsonProperty(value="alg") String alg, @JsonProperty(value="kty") String kty, @JsonProperty(value="use") String use, @JsonProperty(value="x5c") List<String> x5c, @JsonProperty(value="n") String n, @JsonProperty(value="e") String e, @JsonProperty(value="kid") String kid, @JsonProperty(value="x5t") String x5t) {
        this.alg = alg;
        this.kty = kty;
        this.use = use;
        this.x5c = x5c;
        this.n = n;
        this.e = e;
        this.kid = kid;
        this.x5t = x5t;
    }

    public RSAPublicKey getPublicKey() {
        KeyFactory kf = Exceptions.uncheck(() -> KeyFactory.getInstance("RSA"), KeyFactory.class);
        BigInteger modulus = new BigInteger(1, Base64.decodeBase64(this.n));
        BigInteger exponent = new BigInteger(1, Base64.decodeBase64(this.e));
        return Exceptions.uncheck(() -> (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(modulus, exponent)), RSAPublicKey.class);
    }
}

