/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.XMLReader;

public class XmlNode {
    protected static final ThreadLocal<XPath> XPATH_CACHE = ThreadLocal.withInitial(() -> {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        return xPathfactory.newXPath();
    });
    protected static final ThreadLocal<Transformer> TRANSFORMER_CACHE = ThreadLocal.withInitial(() -> {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            transformerFactory = TransformerFactory.newInstance();
        }
        transformerFactory.setAttribute("indent-number", 2);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            return Exceptions.throwUnchecked(e, Transformer.class);
        }
    });
    private static final Class<XMLReader> DOM2SAX_XMLREADER_CLASS = XmlNode.getDom2SaxAvailability();
    private final Node domNode;
    private final Map<String, String> attributes;

    private static Class<XMLReader> getDom2SaxAvailability() {
        try {
            return Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.DOM2SAX");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public XmlNode(Node domNode) {
        this.domNode = domNode;
        this.attributes = domNode.hasAttributes() ? XmlNode.convertAttributeMap(domNode.getAttributes()) : Collections.emptyMap();
    }

    private static Map<String, String> convertAttributeMap(NamedNodeMap namedNodeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            map.put(node.getNodeName(), node.getNodeValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected static ListOrSingle<XmlNode> toListOrSingle(NodeList nodeList) {
        ListOrSingle<XmlNode> nodes = new ListOrSingle<XmlNode>(new XmlNode[0]);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(new XmlNode(nodeList.item(i)));
        }
        return nodes;
    }

    public String getName() {
        return this.domNode.getNodeName();
    }

    public String getText() {
        return this.domNode.getTextContent();
    }

    public String toString() {
        switch (this.domNode.getNodeType()) {
            case 2: 
            case 3: {
                return this.domNode.getTextContent();
            }
            case 1: 
            case 9: {
                return this.render();
            }
        }
        return this.domNode.toString();
    }

    private String render() {
        try {
            Transformer transformer = TRANSFORMER_CACHE.get();
            StreamResult result = new StreamResult(new StringWriter());
            Source source2 = XmlNode.getSourceForTransform(this.domNode);
            transformer.transform(source2, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private static Source getSourceForTransform(Node node) {
        if (DOM2SAX_XMLREADER_CLASS != null) {
            try {
                Constructor<XMLReader> constructor = DOM2SAX_XMLREADER_CLASS.getConstructor(Node.class);
                XMLReader dom2SAX = constructor.newInstance(node);
                SAXSource saxSource = new SAXSource();
                saxSource.setXMLReader(dom2SAX);
                return saxSource;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return new DOMSource(node);
            }
        }
        return new DOMSource(node);
    }
}

