/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net.client;

import com.auth0.client.LoggingOptions;
import com.auth0.client.ProxyOptions;
import com.auth0.net.RateLimitInterceptor;
import com.auth0.net.TelemetryInterceptor;
import com.auth0.net.client.Auth0FormRequestBody;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.Auth0HttpRequest;
import com.auth0.net.client.Auth0HttpResponse;
import com.auth0.net.client.Auth0MultipartRequestBody;
import com.auth0.net.client.HttpMethod;
import com.auth0.net.client.HttpRequestBody;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

public class DefaultHttpClient
implements Auth0HttpClient {
    private final OkHttpClient client;

    public static Builder newBuilder() {
        return new Builder();
    }

    DefaultHttpClient(OkHttpClient client) {
        this.client = client;
    }

    OkHttpClient getOkClient() {
        return this.client;
    }

    private DefaultHttpClient(Builder builder) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.readTimeout(this.sanitizeTimeout(builder.readTimeout), TimeUnit.SECONDS);
        clientBuilder.connectTimeout(this.sanitizeTimeout(builder.connectTimeout), TimeUnit.SECONDS);
        clientBuilder.addInterceptor(this.getLoggingInterceptor(builder.loggingOptions));
        clientBuilder.addInterceptor(this.getTelemetryInterceptor(builder.telemetryEnabled));
        clientBuilder.addInterceptor(this.getRateLimitInterceptor(builder.maxRetries));
        clientBuilder.dispatcher(this.getDispatcher(builder.maxRequests, builder.maxRequestsPerHost));
        this.configureProxy(clientBuilder, builder.proxyOptions);
        this.client = clientBuilder.build();
    }

    private int sanitizeTimeout(int val) {
        return Math.max(val, 0);
    }

    @Override
    public Auth0HttpResponse sendRequest(Auth0HttpRequest request) throws IOException {
        Request okRequest = this.buildRequest(request);
        try (Response response = this.client.newCall(okRequest).execute();){
            Auth0HttpResponse auth0HttpResponse = this.buildResponse(response);
            return auth0HttpResponse;
        }
    }

    @Override
    public CompletableFuture<Auth0HttpResponse> sendRequestAsync(Auth0HttpRequest request) {
        final CompletableFuture<Auth0HttpResponse> future = new CompletableFuture<Auth0HttpResponse>();
        Request okRequest = this.buildRequest(request);
        this.client.newCall(okRequest).enqueue(new Callback(){

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    future.complete(DefaultHttpClient.this.buildResponse(response));
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    private Request buildRequest(Auth0HttpRequest a0Request) {
        RequestBody okBody = this.addBody(a0Request);
        Request.Builder builder = new Request.Builder().url(a0Request.getUrl()).method(a0Request.getMethod().toString(), okBody);
        for (Map.Entry<String, String> e : a0Request.getHeaders().entrySet()) {
            builder.addHeader(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    private Auth0HttpResponse buildResponse(Response okResponse) throws IOException {
        Headers okHeaders = okResponse.headers();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < okHeaders.size(); ++i) {
            headers.put(okHeaders.name(i), okHeaders.value(i));
        }
        ResponseBody responseBody = okResponse.body();
        String content = null;
        if (Objects.nonNull(responseBody)) {
            content = responseBody.string();
        }
        return Auth0HttpResponse.newBuilder().withStatusCode(okResponse.code()).withBody(content).withHeaders(headers).build();
    }

    private RequestBody addBody(Auth0HttpRequest request) {
        RequestBody okBody;
        if (Objects.isNull(request.getBody()) || HttpMethod.GET.equals((Object)request.getMethod())) {
            return null;
        }
        HttpRequestBody body = request.getBody();
        if (Objects.nonNull(body.getFormRequestBody())) {
            Auth0FormRequestBody formData = body.getFormRequestBody();
            FormBody.Builder builder = new FormBody.Builder();
            Iterator<Map.Entry<String, Object>> iterator2 = formData.getParams().entrySet().iterator();
            while (iterator2.hasNext()) {
                Object val;
                Map.Entry<String, Object> entry;
                builder.add(entry.getKey(), (val = (entry = iterator2.next()).getValue()) instanceof String ? (String)val : val.toString());
            }
            okBody = builder.build();
        } else if (Objects.nonNull(body.getMultipartRequestBody())) {
            Auth0MultipartRequestBody multipartRequestBody = body.getMultipartRequestBody();
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (Objects.nonNull(multipartRequestBody.getFilePart())) {
                bodyBuilder.addFormDataPart(multipartRequestBody.getFilePart().getPartName(), multipartRequestBody.getFilePart().getFile().getName(), RequestBody.create(MediaType.parse(multipartRequestBody.getFilePart().getMediaType()), multipartRequestBody.getFilePart().getFile()));
            }
            multipartRequestBody.getParts().forEach(bodyBuilder::addFormDataPart);
            okBody = bodyBuilder.build();
        } else {
            okBody = RequestBody.create(MediaType.parse(request.getBody().getContentType()), request.getBody().getContent());
        }
        return okBody;
    }

    private HttpLoggingInterceptor getLoggingInterceptor(LoggingOptions loggingOptions) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        if (Objects.isNull(loggingOptions)) {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            return loggingInterceptor;
        }
        switch (loggingOptions.getLogLevel()) {
            case BASIC: {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case BODY: {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
            default: {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
        }
        for (String header : loggingOptions.getHeadersToRedact()) {
            loggingInterceptor.redactHeader(header);
        }
        return loggingInterceptor;
    }

    private void configureProxy(OkHttpClient.Builder clientBuilder, ProxyOptions proxyOptions) {
        if (Objects.nonNull(proxyOptions)) {
            clientBuilder.proxy(proxyOptions.getProxy());
            final String proxyAuth = proxyOptions.getBasicAuthentication();
            if (Objects.nonNull(proxyAuth)) {
                clientBuilder.proxyAuthenticator(new Authenticator(){
                    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";

                    @Override
                    public Request authenticate(Route route, @NotNull Response response) {
                        if (Objects.nonNull(response.request().header(PROXY_AUTHORIZATION_HEADER))) {
                            return null;
                        }
                        return response.request().newBuilder().header(PROXY_AUTHORIZATION_HEADER, proxyAuth).build();
                    }
                });
            }
        }
    }

    private TelemetryInterceptor getTelemetryInterceptor(boolean telemetryEnabled) {
        TelemetryInterceptor interceptor = new TelemetryInterceptor();
        interceptor.setEnabled(telemetryEnabled);
        return interceptor;
    }

    private RateLimitInterceptor getRateLimitInterceptor(int maxRetries) {
        if (maxRetries < 0 || maxRetries > 10) {
            throw new IllegalArgumentException("Retries must be between zero and ten.");
        }
        return new RateLimitInterceptor(maxRetries);
    }

    private Dispatcher getDispatcher(int maxRequests, int maxRequestsPerHost) {
        if (maxRequests < 1) {
            throw new IllegalArgumentException("maxRequests must be one or greater.");
        }
        if (maxRequestsPerHost < 1) {
            throw new IllegalArgumentException("maxRequestsPerHost must be one or greater.");
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(maxRequests);
        dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
        return dispatcher;
    }

    public static class Builder {
        private int readTimeout = 10;
        private int connectTimeout = 10;
        private ProxyOptions proxyOptions;
        private LoggingOptions loggingOptions;
        private boolean telemetryEnabled = true;
        private int maxRetries = 3;
        private int maxRequests = 64;
        private int maxRequestsPerHost = 5;

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withLogging(LoggingOptions loggingOptions) {
            this.loggingOptions = loggingOptions;
            return this;
        }

        public Builder withProxy(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder telemetryEnabled(boolean telemetryEnabled) {
            this.telemetryEnabled = telemetryEnabled;
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withMaxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public Builder withMaxRequestsPerHost(int maxRequestsPerHost) {
            this.maxRequestsPerHost = maxRequestsPerHost;
            return this;
        }

        public DefaultHttpClient build() {
            return new DefaultHttpClient(this);
        }
    }
}

