/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.RulesFilter;
import com.auth0.json.mgmt.rules.Rule;
import com.auth0.json.mgmt.rules.RulesPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class RulesEntity
extends BaseManagementEntity {
    RulesEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<RulesPage> listAll(RulesFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<RulesPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<RulesPage>(){});
    }

    public Request<Rule> get(String ruleId, RulesFilter filter) {
        Asserts.assertNotNull(ruleId, "rule id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<Rule>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Rule>(){});
    }

    public Request<Rule> create(Rule rule) {
        Asserts.assertNotNull(rule, "rule");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").build().toString();
        BaseRequest<Rule> request = new BaseRequest<Rule>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Rule>(){});
        request.setBody(rule);
        return request;
    }

    public Request<Void> delete(String ruleId) {
        Asserts.assertNotNull(ruleId, "rule id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Rule> update(String ruleId, Rule rule) {
        Asserts.assertNotNull(ruleId, "rule id");
        Asserts.assertNotNull(rule, "rule");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId).build().toString();
        BaseRequest<Rule> request = new BaseRequest<Rule>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Rule>(){});
        request.setBody(rule);
        return request;
    }
}

