/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.emailproviders.EmailProvider;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class EmailProviderEntity
extends BaseManagementEntity {
    EmailProviderEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<EmailProvider> get(FieldsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<EmailProvider>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<EmailProvider>(){});
    }

    public Request<EmailProvider> setup(EmailProvider emailProvider) {
        Asserts.assertNotNull(emailProvider, "email provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        BaseRequest<EmailProvider> request = new BaseRequest<EmailProvider>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<EmailProvider>(){});
        request.setBody(emailProvider);
        return request;
    }

    public Request<Void> delete() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<EmailProvider> update(EmailProvider emailProvider) {
        Asserts.assertNotNull(emailProvider, "email provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        BaseRequest<EmailProvider> request = new BaseRequest<EmailProvider>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<EmailProvider>(){});
        request.setBody(emailProvider);
        return request;
    }
}

