/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.DeviceCredentialsFilter;
import com.auth0.json.mgmt.devicecredentials.DeviceCredentials;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class DeviceCredentialsEntity
extends BaseManagementEntity {
    DeviceCredentialsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<DeviceCredentials>> list(DeviceCredentialsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<List<DeviceCredentials>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<DeviceCredentials>>(){});
    }

    public Request<DeviceCredentials> create(DeviceCredentials deviceCredentials) {
        Asserts.assertNotNull(deviceCredentials, "device credentials");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials").build().toString();
        BaseRequest<DeviceCredentials> request = new BaseRequest<DeviceCredentials>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<DeviceCredentials>(){});
        request.setBody(deviceCredentials);
        return request;
    }

    public Request<Void> delete(String deviceCredentialsId) {
        Asserts.assertNotNull(deviceCredentialsId, "device credentials id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials").addPathSegment(deviceCredentialsId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

