/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.ClientFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.client.Client;
import com.auth0.json.mgmt.client.ClientsPage;
import com.auth0.json.mgmt.client.Credential;
import com.auth0.net.BaseRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class ClientsEntity
extends BaseManagementEntity {
    ClientsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<ClientsPage> list(ClientFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/clients");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<ClientsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ClientsPage>(){});
    }

    public Request<Client> get(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        return new BaseRequest<Client>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Client>(){});
    }

    public Request<Client> get(String clientId, FieldsFilter filter) {
        Asserts.assertNotNull(clientId, "client id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<Client>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Client>(){});
    }

    public Request<Client> create(Client client) {
        Asserts.assertNotNull(client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").build().toString();
        BaseRequest<Client> request = new BaseRequest<Client>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Client>(){});
        request.setBody(client);
        return request;
    }

    public Request<Void> delete(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Client> update(String clientId, Client client) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        BaseRequest<Client> request = new BaseRequest<Client>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Client>(){});
        request.setBody(client);
        return request;
    }

    public Request<Client> rotateSecret(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(this.client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("rotate-secret").build().toString();
        return new EmptyBodyRequest<Client>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Client>(){});
    }

    public Request<Credential> createCredential(String clientId, Credential credential) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("credentials").build().toString();
        BaseRequest<Credential> request = new BaseRequest<Credential>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Credential>(){});
        request.setBody(credential);
        return request;
    }

    public Request<List<Credential>> listCredentials(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("credentials").build().toString();
        return new BaseRequest<List<Credential>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<Credential>>(){});
    }

    public Request<Credential> getCredential(String clientId, String credentialId) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(credentialId, "credential id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("credentials").addPathSegment(credentialId).build().toString();
        return new BaseRequest<Credential>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Credential>(){});
    }

    public Request<Void> deleteCredential(String clientId, String credentialId) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(credentialId, "credential id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("credentials").addPathSegment(credentialId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

