/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.ClientGrantsFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.json.mgmt.clientgrants.ClientGrant;
import com.auth0.json.mgmt.clientgrants.ClientGrantsPage;
import com.auth0.json.mgmt.organizations.OrganizationsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class ClientGrantsEntity
extends BaseManagementEntity {
    ClientGrantsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<ClientGrantsPage> list(ClientGrantsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<ClientGrantsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ClientGrantsPage>(){});
    }

    public Request<ClientGrant> create(String clientId, String audience, String[] scope) {
        return this.create(clientId, audience, scope, null, null);
    }

    public Request<ClientGrant> create(String clientId, String audience, String[] scope, String orgUsage, Boolean allowAnyOrg) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(audience, "audience");
        Asserts.assertNotNull(scope, "scope");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").build().toString();
        BaseRequest<ClientGrant> request = new BaseRequest<ClientGrant>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<ClientGrant>(){});
        request.addParameter("client_id", clientId);
        request.addParameter("audience", audience);
        request.addParameter("scope", scope);
        if (orgUsage != null && !orgUsage.trim().isEmpty()) {
            request.addParameter("organization_usage", orgUsage);
        }
        if (allowAnyOrg != null) {
            request.addParameter("allow_any_organization", allowAnyOrg);
        }
        return request;
    }

    public Request<Void> delete(String clientGrantId) {
        Asserts.assertNotNull(clientGrantId, "client grant id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").addPathSegment(clientGrantId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<ClientGrant> update(String clientGrantId, String[] scope) {
        return this.update(clientGrantId, scope, null, null);
    }

    public Request<ClientGrant> update(String clientGrantId, String[] scope, String orgUsage, Boolean allowAnyOrg) {
        Asserts.assertNotNull(clientGrantId, "client grant id");
        Asserts.assertNotNull(scope, "scope");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").addPathSegment(clientGrantId).build().toString();
        BaseRequest<ClientGrant> request = new BaseRequest<ClientGrant>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<ClientGrant>(){});
        request.addParameter("scope", scope);
        if (orgUsage != null && !orgUsage.trim().isEmpty()) {
            request.addParameter("organization_usage", orgUsage);
        }
        if (allowAnyOrg != null) {
            request.addParameter("allow_any_organization", allowAnyOrg);
        }
        return request;
    }

    public Request<OrganizationsPage> listOrganizations(String clientGrantId, PageFilter filter) {
        Asserts.assertNotNull(clientGrantId, "client grant ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").addPathSegment(clientGrantId).addPathSegment("organizations");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<OrganizationsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<OrganizationsPage>(){});
    }
}

