/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.ActionsFilter;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.json.mgmt.actions.Action;
import com.auth0.json.mgmt.actions.ActionsPage;
import com.auth0.json.mgmt.actions.BindingsPage;
import com.auth0.json.mgmt.actions.BindingsUpdateRequest;
import com.auth0.json.mgmt.actions.Execution;
import com.auth0.json.mgmt.actions.Triggers;
import com.auth0.json.mgmt.actions.Version;
import com.auth0.json.mgmt.actions.VersionsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.net.client.HttpRequestBody;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class ActionsEntity
extends BaseManagementEntity {
    private static final String ACTIONS_BASE_PATH = "api/v2/actions";
    private static final String ACTIONS_PATH = "actions";
    private static final String TRIGGERS_PATH = "triggers";
    private static final String DEPLOY_PATH = "deploy";
    private static final String VERSIONS_PATH = "versions";
    private static final String EXECUTIONS_PATH = "executions";
    private static final String BINDINGS_PATH = "bindings";

    ActionsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<Action> create(Action action) {
        Asserts.assertNotNull(action, "action");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH);
        String url = builder.build().toString();
        BaseRequest<Action> request = new BaseRequest<Action>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Action>(){});
        request.setBody(action);
        return request;
    }

    public Request<Action> get(String actionId) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).build().toString();
        return new BaseRequest<Action>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Action>(){});
    }

    public Request<Void> delete(String actionId) {
        return this.delete(actionId, false);
    }

    public Request<Void> delete(String actionId, boolean force) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addQueryParameter("force", String.valueOf(force)).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Triggers> getTriggers() {
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).build().toString();
        return new BaseRequest<Triggers>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Triggers>(){});
    }

    public Request<Action> update(String actionId, Action action) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(action, "action");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).build().toString();
        BaseRequest<Action> request = new BaseRequest<Action>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Action>(){});
        request.setBody(action);
        return request;
    }

    public Request<Version> deploy(String actionId) {
        Asserts.assertNotNull(actionId, "action ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(DEPLOY_PATH).build().toString();
        return new EmptyBodyRequest<Version>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Version>(){});
    }

    public Request<Version> getVersion(String actionId, String actionVersionId) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(actionVersionId, "action version ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH).addPathSegment(actionVersionId).build().toString();
        return new BaseRequest<Version>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Version>(){});
    }

    public Request<Version> rollBackToVersion(String actionId, String actionVersionId) {
        Asserts.assertNotNull(actionId, "action ID");
        Asserts.assertNotNull(actionVersionId, "action version ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH).addPathSegment(actionVersionId).addPathSegment(DEPLOY_PATH).build().toString();
        return new EmptyObjectRequest<Version>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Version>(){});
    }

    public Request<Execution> getExecution(String executionId) {
        Asserts.assertNotNull(executionId, "execution ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(EXECUTIONS_PATH).addPathSegment(executionId).build().toString();
        return new BaseRequest<Execution>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Execution>(){});
    }

    public Request<ActionsPage> list(ActionsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<ActionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ActionsPage>(){});
    }

    public Request<VersionsPage> getVersions(String actionId, PageFilter filter) {
        Asserts.assertNotNull(actionId, "action ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(ACTIONS_PATH).addPathSegment(actionId).addPathSegment(VERSIONS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<VersionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<VersionsPage>(){});
    }

    public Request<BindingsPage> getTriggerBindings(String triggerId, PageFilter filter) {
        Asserts.assertNotNull(triggerId, "trigger ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).addPathSegment(triggerId).addPathSegment(BINDINGS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        return new BaseRequest<BindingsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<BindingsPage>(){});
    }

    public Request<BindingsPage> updateTriggerBindings(String triggerId, BindingsUpdateRequest bindingsUpdateRequest) {
        Asserts.assertNotNull(triggerId, "trigger ID");
        Asserts.assertNotNull(bindingsUpdateRequest, "request body");
        String url = this.baseUrl.newBuilder().addPathSegments(ACTIONS_BASE_PATH).addPathSegment(TRIGGERS_PATH).addPathSegment(triggerId).addPathSegment(BINDINGS_PATH).build().toString();
        BaseRequest<BindingsPage> request = new BaseRequest<BindingsPage>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<BindingsPage>(){});
        request.setBody(bindingsUpdateRequest);
        return request;
    }

    private void applyFilter(BaseFilter filter, HttpUrl.Builder builder) {
        if (filter != null) {
            filter.getAsMap().forEach((k, v) -> builder.addQueryParameter((String)k, String.valueOf(v)));
        }
    }

    private static class EmptyObjectRequest<T>
    extends EmptyBodyRequest<T> {
        EmptyObjectRequest(Auth0HttpClient client, TokenProvider tokenProvider, String url, HttpMethod method, TypeReference<T> tType) {
            super(client, tokenProvider, url, method, tType);
        }

        @Override
        protected HttpRequestBody createRequestBody() {
            return HttpRequestBody.create("application/json", "{}".getBytes());
        }
    }
}

