/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.security.SecurityDomainContextAdaptor;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SecurityUtil;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.management.ManagedEndpoint;
import org.jboss.ws.common.monitoring.ManagedRecordProcessor;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class EndpointService
implements Service<Endpoint> {
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final Endpoint endpoint;
    private final ServiceName name;
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final InjectedValue<MBeanServer> mBeanServerValue = new InjectedValue();

    private EndpointService(Endpoint endpoint, ServiceName name) {
        this.endpoint = endpoint;
        this.name = name;
    }

    public Endpoint getValue() {
        return this.endpoint;
    }

    public static ServiceName getServiceName(DeploymentUnit unit, String endpointName) {
        if (unit.getParent() != null) {
            return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getParent().getName()}).append(new String[]{unit.getName()}).append(new String[]{endpointName});
        }
        return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getName()}).append(new String[]{endpointName});
    }

    public void start(StartContext context) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        this.endpoint.setSecurityDomainContext((org.jboss.wsf.spi.security.SecurityDomainContext)new SecurityDomainContextAdaptor((SecurityDomainContext)this.securityDomainContextValue.getValue()));
        List processors = this.endpoint.getRecordProcessors();
        for (RecordProcessor processor : processors) {
            this.registerRecordProcessor(processor, this.endpoint);
        }
        this.registerEndpoint(this.endpoint);
        this.endpoint.getLifecycleHandler().start(this.endpoint);
    }

    public void stop(StopContext context) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        this.endpoint.getLifecycleHandler().stop(this.endpoint);
        this.endpoint.setSecurityDomainContext(null);
        this.unregisterEndpoint(this.endpoint);
        List processors = this.endpoint.getRecordProcessors();
        for (RecordProcessor processor : processors) {
            this.unregisterRecordProcessor(processor, this.endpoint);
        }
    }

    private void registerEndpoint(Endpoint ep) {
        MBeanServer mbeanServer = (MBeanServer)this.mBeanServerValue.getValue();
        if (mbeanServer != null) {
            try {
                ManagedEndpoint jmxEndpoint = new ManagedEndpoint(this.endpoint, mbeanServer);
                mbeanServer.registerMBean(jmxEndpoint, this.endpoint.getName());
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot register endpoint in JMX server", ex);
                WSLogger.ROOT_LOGGER.cannotRegisterEndpoint(this.endpoint.getShortName());
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(this.endpoint.getShortName());
        }
    }

    private void unregisterEndpoint(Endpoint ep) {
        MBeanServer mbeanServer = (MBeanServer)this.mBeanServerValue.getValue();
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(this.endpoint.getName());
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot unregister endpoint from JMX server", ex);
                WSLogger.ROOT_LOGGER.cannotUnregisterEndpoint(this.endpoint.getShortName());
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(this.endpoint.getShortName());
        }
    }

    private void registerRecordProcessor(RecordProcessor processor, Endpoint ep) {
        MBeanServer mbeanServer = (MBeanServer)this.mBeanServerValue.getValue();
        if (mbeanServer != null) {
            try {
                mbeanServer.registerMBean(processor, ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot register endpoint in JMX server, trying with the default ManagedRecordProcessor", ex);
                try {
                    mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
                }
                catch (JMException e) {
                    WSLogger.ROOT_LOGGER.cannotRegisterRecordProcessor();
                }
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(processor);
        }
    }

    private void unregisterRecordProcessor(RecordProcessor processor, Endpoint ep) {
        MBeanServer mbeanServer = (MBeanServer)this.mBeanServerValue.getValue();
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException e) {
                WSLogger.ROOT_LOGGER.cannotUnregisterRecordProcessor();
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(processor);
        }
    }

    public Injector<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextValue;
    }

    public Injector<MBeanServer> getMBeanServerInjector() {
        return this.mBeanServerValue;
    }

    public static void install(ServiceTarget serviceTarget, Endpoint endpoint, DeploymentUnit unit) {
        ServiceName serviceName = EndpointService.getServiceName(unit, endpoint.getShortName());
        String propContext = endpoint.getName().getKeyProperty("context");
        String propEndpoint = endpoint.getName().getKeyProperty("endpoint");
        StringBuilder context = new StringBuilder("context").append("=").append(propContext);
        EndpointService service = new EndpointService(endpoint, serviceName);
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        ServiceName alias = WSServices.ENDPOINT_SERVICE.append(new String[]{context.toString()}).append(new String[]{propEndpoint});
        builder.addAliases(new ServiceName[]{alias});
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{EndpointService.getDeploymentSecurityDomainName(endpoint)}), SecurityDomainContext.class, service.getSecurityDomainContextInjector());
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.CONFIG_SERVICE);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, MBEAN_SERVER_NAME, MBeanServer.class, service.getMBeanServerInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    public static void uninstall(Endpoint endpoint, DeploymentUnit unit) {
        ServiceName serviceName = EndpointService.getServiceName(unit, endpoint.getShortName());
        ServiceController endpointService = WSServices.getContainerRegistry().getService(serviceName);
        if (endpointService != null) {
            endpointService.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private static String getDeploymentSecurityDomainName(Endpoint ep) {
        JBossWebMetaData metadata = (JBossWebMetaData)ep.getService().getDeployment().getAttachment(JBossWebMetaData.class);
        String metaDataSecurityDomain = metadata != null ? metadata.getSecurityDomain() : null;
        return metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain.trim());
    }
}

