/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import java.util.function.UnaryOperator;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;
import org.wildfly.extension.undertow.deployment.SuspendedServerHandlerWrapper;

public class SuspendedServerRequestListener
implements ServletRequestListener,
UnaryOperator<DeploymentInfo>,
ExchangeCompletionListener {
    private final ControlPoint entryPoint;

    public SuspendedServerRequestListener(ControlPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Override
    public DeploymentInfo apply(DeploymentInfo deployment) {
        deployment.addListener(new ListenerInfo(ServletRequestListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)this)));
        return deployment;
    }

    public void requestDestroyed(ServletRequestEvent event) {
        HttpServerExchange exchange = ServletRequestContext.requireCurrent().getExchange();
        if (exchange.removeAttachment(SuspendedServerHandlerWrapper.RUN_RESULT_KEY) == RunResult.RUN) {
            if (exchange.isComplete()) {
                this.entryPoint.requestComplete();
            } else {
                exchange.addExchangeCompleteListener((ExchangeCompletionListener)this);
            }
        }
    }

    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        try {
            nextListener.proceed();
        }
        finally {
            this.entryPoint.requestComplete();
        }
    }
}

