/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.extension.undertow.AbstractHttpListenerResourceDefinition;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.AffinityCookieDefinition;
import org.wildfly.extension.undertow.AjpListenerResourceDefinition;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.ByteBufferPoolDefinition;
import org.wildfly.extension.undertow.ConsoleAccessLogDefinition;
import org.wildfly.extension.undertow.CrawlerSessionManagementDefinition;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.HttpInvokerDefinition;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.LocationDefinition;
import org.wildfly.extension.undertow.MimeMappingDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.WelcomeFileDefinition;
import org.wildfly.extension.undertow.filters.CustomFilterDefinition;
import org.wildfly.extension.undertow.filters.ErrorPageDefinition;
import org.wildfly.extension.undertow.filters.ExpressionFilterDefinition;
import org.wildfly.extension.undertow.filters.FilterDefinitions;
import org.wildfly.extension.undertow.filters.FilterRefDefinition;
import org.wildfly.extension.undertow.filters.GzipFilterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.NoAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.RankedAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.RequestLimitHandlerDefinition;
import org.wildfly.extension.undertow.filters.ResponseHeaderFilterDefinition;
import org.wildfly.extension.undertow.filters.RewriteFilterDefinition;
import org.wildfly.extension.undertow.filters.SingleAffinityResourceDefinition;
import org.wildfly.extension.undertow.handlers.FileHandlerDefinition;
import org.wildfly.extension.undertow.handlers.HandlerDefinitions;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerDefinition;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerHostDefinition;

public enum UndertowSubsystemSchema implements PersistentSubsystemSchema<UndertowSubsystemSchema>
{
    VERSION_3_1(3, 1),
    VERSION_4_0(4),
    VERSION_5_0(5),
    VERSION_6_0(6),
    VERSION_7_0(7),
    VERSION_8_0(8),
    VERSION_9_0(9),
    VERSION_10_0(10),
    VERSION_11_0(11),
    VERSION_12_0(12),
    VERSION_13_0(13),
    VERSION_14_0(14),
    VERSION_14_0_PREVIEW(14, 0, Stability.PREVIEW),
    VERSION_14_0_COMMUNITY(14, 0, Stability.COMMUNITY);

    static final Map<Stability, UndertowSubsystemSchema> CURRENT;
    private final VersionedNamespace<IntVersion, UndertowSubsystemSchema> namespace;
    private final PersistentResourceXMLDescription.Factory factory = PersistentResourceXMLDescription.factory((PersistentSubsystemSchema)this);

    private UndertowSubsystemSchema(int major) {
        this(new IntVersion(new int[]{major}));
    }

    private UndertowSubsystemSchema(int major, int minor) {
        this(new IntVersion(new int[]{major, minor}));
    }

    private UndertowSubsystemSchema(IntVersion version) {
        this(version, Stability.DEFAULT);
    }

    private UndertowSubsystemSchema(int major, int minor, Stability stability) {
        this(new IntVersion(new int[]{major, minor}), stability);
    }

    private UndertowSubsystemSchema(IntVersion version, Stability stability) {
        this.namespace = SubsystemSchema.createLegacySubsystemURN((String)"undertow", (Stability)stability, (IntVersion)version);
    }

    public VersionedNamespace<IntVersion, UndertowSubsystemSchema> getNamespace() {
        return this.namespace;
    }

    public PersistentResourceXMLDescription getXMLDescription() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(UndertowRootDefinition.PATH_ELEMENT);
        if (this.since((VersionedFeature)VERSION_6_0)) {
            builder.addChild(this.factory.builder(ByteBufferPoolDefinition.PATH_ELEMENT).addAttributes(ByteBufferPoolDefinition.ATTRIBUTES.stream()).build());
        }
        builder.addChild(this.factory.builder(BufferCacheDefinition.PATH_ELEMENT).addAttributes(BufferCacheDefinition.ATTRIBUTES.stream()).build());
        builder.addChild(this.factory.builder(ServerDefinition.PATH_ELEMENT).addAttributes(ServerDefinition.ATTRIBUTES.stream()).addChild(this.ajpListener()).addChild(this.httpListener()).addChild(this.httpsListener()).addChild(this.host()).build());
        builder.addChild(this.servletContainer());
        builder.addChild(this.handlers());
        builder.addChild(this.factory.builder(FilterDefinitions.PATH_ELEMENT).setXmlElementName("filters").setNoAddOperation(true).addChild(this.factory.builder(RequestLimitHandlerDefinition.PATH_ELEMENT).addAttributes(RequestLimitHandlerDefinition.ATTRIBUTES.stream()).build()).addChild(this.factory.builder(ResponseHeaderFilterDefinition.PATH_ELEMENT).addAttributes(ResponseHeaderFilterDefinition.ATTRIBUTES.stream()).build()).addChild(this.factory.builder(GzipFilterDefinition.PATH_ELEMENT).build()).addChild(this.factory.builder(ErrorPageDefinition.PATH_ELEMENT).addAttributes(ErrorPageDefinition.ATTRIBUTES.stream()).build()).addChild(this.modCluster()).addChild(this.factory.builder(CustomFilterDefinition.PATH_ELEMENT).addAttributes(CustomFilterDefinition.ATTRIBUTES.stream()).setXmlElementName("filter").build()).addChild(this.factory.builder(ExpressionFilterDefinition.PATH_ELEMENT).addAttributes(ExpressionFilterDefinition.ATTRIBUTES.stream()).build()).addChild(this.factory.builder(RewriteFilterDefinition.PATH_ELEMENT).addAttributes(RewriteFilterDefinition.ATTRIBUTES.stream()).build()).build());
        if (this.since((VersionedFeature)VERSION_4_0)) {
            builder.addChild(this.applicationSecurityDomain());
        }
        builder.setAdditionalOperationsGenerator((address, addOperation, operations) -> {
            operations.add(Util.createAddOperation((PathAddress)address.append(new PathElement[]{FilterDefinitions.PATH_ELEMENT})));
            operations.add(Util.createAddOperation((PathAddress)address.append(new PathElement[]{HandlerDefinitions.PATH_ELEMENT})));
        });
        Stream<AttributeDefinition> attributes = UndertowRootDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_12_0)) {
            attributes = attributes.filter(Predicate.isEqual(UndertowRootDefinition.OBFUSCATE_SESSION_ROUTE).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription ajpListener() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(AjpListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = AjpListenerResourceDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_14_0_COMMUNITY)) {
            attributes = attributes.filter(Predicate.isEqual(AjpListenerResourceDefinition.ALLOWED_REQUEST_ATTRIBUTES_PATTERN).negate());
        }
        Stream.concat(this.listenerAttributes(), attributes).forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription httpListener() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(HttpListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = HttpListenerResourceDefinition.ATTRIBUTES.stream();
        Stream.of(this.listenerAttributes(), attributes, this.httpListenerAttributes()).flatMap(Function.identity()).forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription httpsListener() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(HttpsListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = HttpsListenerResourceDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(HttpsListenerResourceDefinition.SSL_CONTEXT).negate());
        }
        Stream<AttributeDefinition> httpListenerAttributes = this.httpListenerAttributes();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            httpListenerAttributes = httpListenerAttributes.filter(Predicate.not(Set.of(AbstractHttpListenerResourceDefinition.CERTIFICATE_FORWARDING, AbstractHttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING)::contains));
        }
        Stream.of(this.listenerAttributes(), attributes, httpListenerAttributes).flatMap(Function.identity()).forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private Stream<AttributeDefinition> httpListenerAttributes() {
        Stream<AttributeDefinition> attributes = AbstractHttpListenerResourceDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(AbstractHttpListenerResourceDefinition.REQUIRE_HOST_HTTP11).negate());
        }
        if (!this.since((VersionedFeature)VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(AbstractHttpListenerResourceDefinition.PROXY_PROTOCOL).negate());
        }
        return attributes;
    }

    private Stream<AttributeDefinition> listenerAttributes() {
        Stream<AttributeDefinition> attributes = ListenerResourceDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION).negate());
        }
        if (!this.since((VersionedFeature)VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(ListenerResourceDefinition.ALLOW_UNESCAPED_CHARACTERS_IN_URL).negate());
        }
        return attributes;
    }

    private PersistentResourceXMLDescription host() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(HostDefinition.PATH_ELEMENT);
        builder.addChild(this.factory.builder(LocationDefinition.PATH_ELEMENT).addAttributes(LocationDefinition.ATTRIBUTES.stream()).addChild(this.filterRef()).build());
        builder.addChild(this.factory.builder(AccessLogDefinition.PATH_ELEMENT).addAttributes(AccessLogDefinition.ATTRIBUTES.stream()).build());
        if (this.since((VersionedFeature)VERSION_9_0)) {
            builder.addChild(this.factory.builder(ConsoleAccessLogDefinition.PATH_ELEMENT).addAttributes(ConsoleAccessLogDefinition.ATTRIBUTES.stream()).build());
        }
        builder.addChild(this.filterRef());
        builder.addChild(this.factory.builder(SingleSignOnDefinition.PATH_ELEMENT).addAttributes(EnumSet.allOf(SingleSignOnDefinition.Attribute.class).stream().map(Supplier::get)).build());
        if (this.since((VersionedFeature)VERSION_4_0)) {
            builder.addChild(this.factory.builder(HttpInvokerDefinition.PATH_ELEMENT).addAttributes(HttpInvokerDefinition.ATTRIBUTES.stream()).build());
        }
        Stream<AttributeDefinition> attributes = HostDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(HostDefinition.QUEUE_REQUESTS_ON_START).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription filterRef() {
        return this.factory.builder(FilterRefDefinition.PATH_ELEMENT).addAttributes(FilterRefDefinition.ATTRIBUTES.stream()).build();
    }

    private PersistentResourceXMLDescription servletContainer() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(ServletContainerDefinition.PATH_ELEMENT);
        builder.addChild(this.factory.builder(JspDefinition.PATH_ELEMENT).addAttributes(JspDefinition.ATTRIBUTES.stream()).setXmlElementName("jsp-config").build());
        if (this.since((VersionedFeature)VERSION_14_0)) {
            builder.addChild(this.factory.builder(AffinityCookieDefinition.PATH_ELEMENT).addAttributes(AffinityCookieDefinition.ATTRIBUTES.stream()).build());
        }
        builder.addChild(this.factory.builder(SessionCookieDefinition.PATH_ELEMENT).addAttributes(SessionCookieDefinition.ATTRIBUTES.stream()).build());
        builder.addChild(this.factory.builder(PersistentSessionsDefinition.PATH_ELEMENT).addAttributes(PersistentSessionsDefinition.ATTRIBUTES.stream()).build());
        builder.addChild(this.websockets());
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)MimeMappingDefinition.PATH_ELEMENT).addAttributes(MimeMappingDefinition.ATTRIBUTES.stream()).setXmlWrapperElement("mime-mappings").build());
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)WelcomeFileDefinition.PATH_ELEMENT).setXmlWrapperElement("welcome-files").build());
        builder.addChild(this.factory.builder(CrawlerSessionManagementDefinition.PATH_ELEMENT).addAttributes(CrawlerSessionManagementDefinition.ATTRIBUTES.stream()).build());
        Stream<AttributeDefinition> attributes = ServletContainerDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE, ServletContainerDefinition.DISABLE_SESSION_ID_REUSE)::contains));
        }
        if (!this.since((VersionedFeature)VERSION_5_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE, ServletContainerDefinition.FILE_CACHE_METADATA_SIZE, ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE)::contains));
        }
        if (!this.since((VersionedFeature)VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(ServletContainerDefinition.DEFAULT_COOKIE_VERSION).negate());
        }
        if (!this.since((VersionedFeature)VERSION_10_0)) {
            attributes = attributes.filter(Predicate.isEqual(ServletContainerDefinition.PRESERVE_PATH_ON_FORWARD).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription websockets() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(WebsocketsDefinition.PATH_ELEMENT);
        Stream<Object> attributes = WebsocketsDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(WebsocketsDefinition.PER_MESSAGE_DEFLATE, WebsocketsDefinition.DEFLATER_LEVEL)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription handlers() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(HandlerDefinitions.PATH_ELEMENT).setXmlElementName("handlers").setNoAddOperation(true);
        builder.addChild(this.factory.builder(FileHandlerDefinition.PATH_ELEMENT).addAttributes(FileHandlerDefinition.ATTRIBUTES.stream()).build());
        Stream<AttributeDefinition> reverseProxyHandlerAttributes = ReverseProxyHandlerDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_14_0_COMMUNITY)) {
            reverseProxyHandlerAttributes = reverseProxyHandlerAttributes.filter(Predicate.not(Set.of(ReverseProxyHandlerDefinition.REUSE_X_FORWARDED_HEADER, ReverseProxyHandlerDefinition.REWRITE_HOST_HEADER)::contains));
        }
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            reverseProxyHandlerAttributes = reverseProxyHandlerAttributes.filter(Predicate.isEqual(ReverseProxyHandlerDefinition.MAX_RETRIES).negate());
        }
        Stream<AttributeDefinition> reverseProxyHandlerHostAttributes = ReverseProxyHandlerHostDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            reverseProxyHandlerHostAttributes = reverseProxyHandlerHostAttributes.filter(Predicate.not(Set.of(ReverseProxyHandlerHostDefinition.SSL_CONTEXT, ReverseProxyHandlerHostDefinition.ENABLE_HTTP2)::contains));
        }
        builder.addChild(this.factory.builder(ReverseProxyHandlerDefinition.PATH_ELEMENT).addAttributes(reverseProxyHandlerAttributes).addChild(this.factory.builder(ReverseProxyHandlerHostDefinition.PATH_ELEMENT).addAttributes(ReverseProxyHandlerHostDefinition.ATTRIBUTES.stream()).setXmlElementName("host").build()).build());
        return builder.build();
    }

    private PersistentResourceXMLDescription modCluster() {
        PersistentResourceXMLDescription.Builder builder = this.factory.builder(ModClusterDefinition.PATH_ELEMENT);
        if (this.since((VersionedFeature)VERSION_10_0)) {
            builder.addChild(this.factory.builder(NoAffinityResourceDefinition.PATH).setXmlElementName("no-affinity").build());
            builder.addChild(this.factory.builder(SingleAffinityResourceDefinition.PATH).setXmlElementName("single-affinity").build());
            builder.addChild(this.factory.builder(RankedAffinityResourceDefinition.PATH).addAttributes(Attribute.stream(RankedAffinityResourceDefinition.Attribute.class)).setXmlElementName("ranked-affinity").build());
        }
        Stream<AttributeDefinition> attributes = ModClusterDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ModClusterDefinition.FAILOVER_STRATEGY, ModClusterDefinition.SSL_CONTEXT, ModClusterDefinition.MAX_RETRIES)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private PersistentResourceXMLDescription applicationSecurityDomain() {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)ApplicationSecurityDomainDefinition.PATH_ELEMENT).setXmlWrapperElement("application-security-domains");
        Stream<AttributeDefinition> ssoAttributes = Stream.concat(EnumSet.allOf(ApplicationSecurityDomainSingleSignOnDefinition.Attribute.class).stream(), EnumSet.allOf(SingleSignOnDefinition.Attribute.class).stream()).map(rec$ -> (AttributeDefinition)((Supplier)rec$).get());
        builder.addChild(this.factory.builder(SingleSignOnDefinition.PATH_ELEMENT).addAttributes(ssoAttributes).build());
        Stream<AttributeDefinition> attributes = ApplicationSecurityDomainDefinition.ATTRIBUTES.stream();
        if (!this.since((VersionedFeature)VERSION_7_0)) {
            attributes = attributes.filter(Predicate.isEqual(ApplicationSecurityDomainDefinition.SECURITY_DOMAIN).negate());
        }
        if (!this.since((VersionedFeature)VERSION_8_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ApplicationSecurityDomainDefinition.ENABLE_JASPI, ApplicationSecurityDomainDefinition.INTEGRATED_JASPI)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.Builder)builder).addAttribute(arg_0));
        return builder.build();
    }

    static {
        CURRENT = Feature.map(EnumSet.of(VERSION_14_0, VERSION_14_0_PREVIEW, VERSION_14_0_COMMUNITY));
    }
}

