/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.subsystem.test.AbstractKernelServicesImpl;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KnownVersions;
import org.jboss.as.subsystem.test.ReadTransformedResourceOperation;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;
import org.xnio.IoUtils;

class MainKernelServicesImpl
extends AbstractKernelServicesImpl {
    private static TransformationTarget.IgnoredTransformationRegistry MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY = new TransformationTarget.IgnoredTransformationRegistry(){

        public boolean isResourceTransformationIgnored(PathAddress address) {
            return false;
        }

        public boolean isOperationTransformationIgnored(PathAddress address) {
            return false;
        }

        public String getHostName() {
            return null;
        }
    };

    protected MainKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, String mainSubsystemName, ExtensionRegistry extensionRegistry, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, boolean registerTransformers) {
        super(container, controllerService, persister, rootRegistration, operationValidator, mainSubsystemName, extensionRegistry, legacyModelVersion, successfulBoot, bootError, registerTransformers);
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        this.checkIsMainController();
        PathElement pathElement = PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName);
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (opAddr.size() > 0 && opAddr.getElement(0).equals(pathElement) || operation.get("operation").asString().equals("composite")) {
            Map<PathAddress, ModelVersion> subsystem = Collections.singletonMap(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{pathElement}), modelVersion);
            TransformationTargetImpl transformationTarget = TransformationTargetImpl.create((TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)this.getCoreModelVersionByLegacyModelVersion(modelVersion), subsystem, (TransformationTarget.IgnoredTransformationRegistry)MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER, null);
            Transformers transformers = Transformers.Factory.create((TransformationTarget)transformationTarget);
            TransformationContext transformationContext = this.createTransformationContext((TransformationTarget)transformationTarget);
            return transformers.transformOperation(transformationContext, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public ModelNode readTransformedModel(ModelVersion modelVersion) {
        this.getLegacyServices(modelVersion);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-transformed-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        op.get("subsystem").set(this.mainSubsystemName);
        ModelNode result = this.internalExecute(op, new ReadTransformedResourceOperation(this.getTransformersRegistry(), this.getCoreModelVersionByLegacyModelVersion(modelVersion), modelVersion));
        return ModelTestUtils.checkResultAndGetContents((ModelNode)result);
    }

    @Override
    public ModelNode executeOperation(ModelVersion modelVersion, final OperationTransformer.TransformedOperation op) {
        KernelServices legacy = (KernelServices)this.getLegacyServices(modelVersion);
        ModelNode result = new ModelNode();
        if (op.getTransformedOperation() != null && op.rejectOperation(result = legacy.executeOperation(op.getTransformedOperation(), new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                if (op.rejectOperation(result)) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
        }))) {
            ModelNode newResponse = new ModelNode();
            newResponse.get("outcome").set("failed");
            newResponse.get("failure-description").set(op.getFailureDescription());
            return newResponse;
        }
        OperationResultTransformer resultTransformer = op.getResultTransformer();
        if (resultTransformer != null) {
            result = resultTransformer.transformResult(result);
        }
        return result;
    }

    private ModelVersion getCoreModelVersionByLegacyModelVersion(ModelVersion legacyModelVersion) {
        if (System.getProperty("jboss.test.core.model.version.override") != null) {
            return ModelVersion.fromString((String)System.getProperty("jboss.test.core.model.version.override"));
        }
        ModelVersion coreModelVersion = KnownVersions.getCoreModelVersionForSubsystemVersion(this.mainSubsystemName, legacyModelVersion);
        if (coreModelVersion != null) {
            return coreModelVersion;
        }
        String fileName = this.mainSubsystemName + "-versions-to-as-versions.properties";
        InputStream in = this.getClass().getResourceAsStream("/" + fileName);
        if (in == null) {
            throw new IllegalArgumentException("Version " + legacyModelVersion + " of " + this.mainSubsystemName + " is not a known version. Please add it to " + KnownVersions.class.getName() + ". Or if that is not possible, " + "include a src/test/resources/" + fileName + " file, which maps AS versions to model versions. E.g.:\n1.1.0=7.1.2\n1.2.0=7.1.3");
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
        String asVersion = (String)props.get(legacyModelVersion.toString());
        if (asVersion == null) {
            throw new IllegalArgumentException("src/test/resources/" + fileName + " does not contain an AS mapping for modelversion + " + legacyModelVersion + "'. It needs to map AS versions to model versions. E.g.:\n1.1.0=7.1.2\n1.2.0=7.1.3");
        }
        coreModelVersion = KnownVersions.AS_CORE_MODEL_VERSION_BY_AS_VERSION.get(asVersion);
        if (coreModelVersion == null) {
            throw new IllegalArgumentException("Unknown AS version '" + asVersion + "' determined from src/test/resources/" + fileName + ". Known AS versions are " + KnownVersions.AS_CORE_MODEL_VERSION_BY_AS_VERSION.keySet());
        }
        return coreModelVersion;
    }
}

