/*
* JBoss, Home of Professional Open Source.
* Copyright 2011, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.as.server.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;

/**
 * Plugin for the {@link PluggableMBeanServer}
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 */
public interface MBeanServerPlugin extends MBeanServer {
    /**
     * Return {@code true} if this plugin can handle mbeans with the passed in name
     *
     * @param objectName the name of the mbean to check
     * @return whether or not this plugin can handle the mbean
     */
    boolean accepts(ObjectName objectName);

    /**
     * Return {@code true} if this plugin should audit log
     *
     * @return whether or not this plugin should audit log
     */
    boolean shouldAuditLog();

    /**
     * Return {@code true} if this plugin should authorize calls
     *
     * @return whether or not this plugin should audit log
     */
    boolean shouldAuthorize();
}