/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.processors.TerminationCoordinatorProcessor;
import com.arjuna.webservices11.wsarjtx.processors.TerminationCoordinatorRPCProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.BusinessActivityTerminator;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.soap.SOAPFaultException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;

public class TerminationCoordinatorRPCProcessorImpl
extends TerminationCoordinatorRPCProcessor {
    @Override
    public void cancel(NotificationType cancel, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = TerminationCoordinatorProcessor.getProcessor().getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    try {
                        participant.cancel();
                        break block10;
                    }
                    catch (FaultedException fm) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.FAULTED_ERROR_CODE_QNAME);
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (UnknownTransactionException ute) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_1());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (SystemException se) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_2());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from close:", (Object)th);
                        }
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_2());
                        throw new SOAPFaultException(soapFault);
                    }
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Cancel called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                SOAPFactory factory = SOAPFactory.newInstance();
                SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_5());
                throw new SOAPFaultException(soapFault);
            }
            catch (SOAPException se) {
                se.printStackTrace(System.err);
                throw new ProtocolException((Throwable)se);
            }
        }
    }

    @Override
    public void close(NotificationType close, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = TerminationCoordinatorProcessor.getProcessor().getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    try {
                        participant.close();
                        break block10;
                    }
                    catch (UnknownTransactionException ute) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_6());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (TransactionRolledBackException trbe) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.TRANSACTIONROLLEDBACK_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_7());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (SystemException se) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_8());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from close:", (Object)th);
                        }
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_8());
                        throw new SOAPFaultException(soapFault);
                    }
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Close called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                SOAPFactory factory = SOAPFactory.newInstance();
                SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_6());
                throw new SOAPFaultException(soapFault);
            }
            catch (SOAPException se) {
                se.printStackTrace(System.err);
                throw new ProtocolException((Throwable)se);
            }
        }
    }

    @Override
    public void complete(NotificationType complete, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = TerminationCoordinatorProcessor.getProcessor().getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    W3CEndpointReference endpoint = participant.getEndpoint();
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.complete();
                        break block10;
                    }
                    catch (FaultedException fm) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.FAULTED_ERROR_CODE_QNAME);
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (UnknownTransactionException ute) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_12());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (SystemException se) {
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_13());
                        throw new SOAPFaultException(soapFault);
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from close:", (Object)th);
                        }
                        SOAPFactory factory = SOAPFactory.newInstance();
                        SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_RECEIVER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                        soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_13());
                        throw new SOAPFaultException(soapFault);
                    }
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Complete called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                SOAPFactory factory = SOAPFactory.newInstance();
                SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_12());
                throw new SOAPFaultException(soapFault);
            }
            catch (SOAPException se) {
                se.printStackTrace(System.err);
                throw new ProtocolException((Throwable)se);
            }
        }
    }
}

