/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;

public final class SecurityDomainContext {
    private final AuthenticationManager authenticationMgr;
    private final AuthorizationManager authorizationMgr;
    private final AuditManager auditMgr;
    private final MappingManager mappingMgr;
    private final IdentityTrustManager identityTrustMgr;
    private final JSSESecurityDomain jsseSecurityDomain;
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";

    public SecurityDomainContext(AuthenticationManager authenticationMgr, AuthorizationManager authorizationMgr, AuditManager auditMgr, IdentityTrustManager identityTrustMgr, MappingManager mappingMgr, JSSESecurityDomain jsseSecurityDomain) {
        this.authenticationMgr = authenticationMgr;
        this.authorizationMgr = authorizationMgr;
        this.auditMgr = auditMgr;
        this.mappingMgr = mappingMgr;
        this.identityTrustMgr = identityTrustMgr;
        this.jsseSecurityDomain = jsseSecurityDomain;
    }

    public Subject getSubject() {
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
        return subject;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationMgr;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationMgr;
    }

    public AuditManager getAuditManager() {
        return this.auditMgr;
    }

    public MappingManager getMappingManager() {
        return this.mappingMgr;
    }

    public IdentityTrustManager getIdentityTrustManager() {
        return this.identityTrustMgr;
    }

    public JSSESecurityDomain getJSSE() {
        return this.jsseSecurityDomain;
    }
}

