/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import com.google.common.base.Predicate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class AnyMatchPredicate<T>
implements Predicate<Iterable<T>> {
    private final Predicate<T> predicate;

    public AnyMatchPredicate(@Nonnull Predicate<T> target) {
        this.predicate = Constraint.isNotNull(target, "Target predicate can not be null");
    }

    public boolean apply(@Nullable Iterable<T> inputs) {
        if (inputs == null) {
            return false;
        }
        for (T input : inputs) {
            if (!this.predicate.apply(input)) continue;
            return true;
        }
        return false;
    }
}

