/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import jakarta.resource.ResourceException;
import java.io.Serializable;
import org.jboss.resource.adapter.jms.util.Strings;

public class JmsMCFProperties
implements Serializable {
    static final long serialVersionUID = -7997396849692340121L;
    public static final String QUEUE_TYPE = Queue.class.getName();
    public static final String TOPIC_TYPE = Topic.class.getName();
    public static final String AGNOSTIC_TYPE = Destination.class.getName();
    public static final String JMS_CONTEXT_TYPE = JMSContext.class.getName();
    String userName;
    char[] password;
    String clientID;
    String jndiParameters;
    String connectionFactory;
    int type = 0;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = Strings.toCharArray(password);
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getJndiParameters() {
        return this.jndiParameters;
    }

    public void setJndiParameters(String jndiParameters) {
        this.jndiParameters = jndiParameters;
    }

    public void setSessionDefaultType(String type) throws ResourceException {
        this.type = QUEUE_TYPE.equals(type) ? 1 : (TOPIC_TYPE.equals(type) ? 2 : (JMS_CONTEXT_TYPE.equals(type) ? 3 : 0));
    }

    public String getSessionDefaultType() {
        switch (this.type) {
            case 1: {
                return QUEUE_TYPE;
            }
            case 2: {
                return TOPIC_TYPE;
            }
            case 3: {
                return JMS_CONTEXT_TYPE;
            }
        }
        return AGNOSTIC_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmsMCFProperties) {
            JmsMCFProperties you = (JmsMCFProperties)obj;
            return Strings.compare(this.userName, you.getUserName()) && Strings.compare(this.password, you.getPassword()) && this.type == you.type;
        }
        return false;
    }

    public int hashCode() {
        String result = "" + this.userName + this.password + this.type;
        return result.hashCode();
    }
}

