/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.soap;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.HttpClientSecurityContext;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.security.SOAPClientSecurityContext;

public class SAMLSOAPClientContextBuilder<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject> {
    private OutboundMessageType outboundMessage;
    private String protocol;
    private String selfEntityID;
    private String peerEntityID;
    private QName peerEntityRole;
    private EntityDescriptor peerEntityDescriptor;
    private RoleDescriptor peerRoleDescriptor;
    private Function<MessageContext<?>, CriteriaSet> tlsCriteriaSetStrategy;
    private String pipelineName;
    private String securityConfigurationProfileId;

    @Nullable
    public OutboundMessageType getOutboundMessage() {
        return this.outboundMessage;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setOutboundMessage(OutboundMessageType message) {
        this.outboundMessage = message;
        return this;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setProtocol(String uri) {
        this.protocol = uri;
        return this;
    }

    @Nullable
    public String getSelfEntityID() {
        return this.selfEntityID;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setSelfEntityID(String entityID) {
        this.selfEntityID = entityID;
        return this;
    }

    @Nullable
    public String getPeerEntityID() {
        if (this.peerEntityID != null) {
            return this.peerEntityID;
        }
        if (this.getPeerEntityDescriptor() != null) {
            return this.getPeerEntityDescriptor().getEntityID();
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityID(String entityID) {
        this.peerEntityID = entityID;
        return this;
    }

    @Nullable
    public QName getPeerEntityRole() {
        if (this.peerEntityRole != null) {
            return this.peerEntityRole;
        }
        if (this.getPeerRoleDescriptor() != null) {
            if (this.getPeerRoleDescriptor().getSchemaType() != null) {
                return this.getPeerRoleDescriptor().getSchemaType();
            }
            return this.getPeerRoleDescriptor().getElementQName();
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityRole(QName role) {
        this.peerEntityRole = role;
        return this;
    }

    @Nullable
    public EntityDescriptor getPeerEntityDescriptor() {
        XMLObject roleParent;
        if (this.peerEntityDescriptor != null) {
            return this.peerEntityDescriptor;
        }
        if (this.getPeerRoleDescriptor() != null && (roleParent = this.getPeerRoleDescriptor().getParent()) instanceof EntityDescriptor) {
            return (EntityDescriptor)roleParent;
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityDescriptor(EntityDescriptor entityDescriptor) {
        this.peerEntityDescriptor = entityDescriptor;
        return this;
    }

    @Nullable
    public RoleDescriptor getPeerRoleDescriptor() {
        return this.peerRoleDescriptor;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerRoleDescriptor(RoleDescriptor roleDescriptor) {
        this.peerRoleDescriptor = roleDescriptor;
        return this;
    }

    @Nullable
    public Function<MessageContext<?>, CriteriaSet> getTLSCriteriaSetStrategy() {
        if (this.tlsCriteriaSetStrategy != null) {
            return this.tlsCriteriaSetStrategy;
        }
        return new DefaultTLSCriteriaSetStrategy();
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setTLSCriteriaSetStrategy(@Nullable Function<MessageContext<?>, CriteriaSet> strategy) {
        this.tlsCriteriaSetStrategy = strategy;
        return this;
    }

    @Nullable
    public String getPipelineName() {
        return this.pipelineName;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPipelineName(@Nullable String name) {
        this.pipelineName = StringSupport.trimOrNull((String)name);
        return this;
    }

    @Nullable
    public String getSecurityConfigurationProfileId() {
        return this.securityConfigurationProfileId;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setSecurityConfigurationProfileId(@Nullable String profileId) {
        this.securityConfigurationProfileId = StringSupport.trimOrNull((String)profileId);
        return this;
    }

    public InOutOperationContext<InboundMessageType, OutboundMessageType> build() throws MessageException {
        QName peerRoleName;
        String peerID;
        String selfID;
        InOutOperationContext opContext;
        if (this.getOutboundMessage() == null) {
            this.errorMissingData("Outbound message");
        }
        MessageContext outboundContext = new MessageContext();
        outboundContext.setMessage(this.getOutboundMessage());
        Function<MessageContext<?>, CriteriaSet> tlsStrategy = this.getTLSCriteriaSetStrategy();
        if (tlsStrategy != null) {
            ((HttpClientSecurityContext)outboundContext.getSubcontext(HttpClientSecurityContext.class, true)).setTLSCriteriaSetStrategy(tlsStrategy);
        }
        InOutOperationContext parent = opContext = new InOutOperationContext(null, outboundContext);
        if (this.getProtocol() != null) {
            ((SAMLProtocolContext)parent.getSubcontext(SAMLProtocolContext.class, true)).setProtocol(this.getProtocol());
        }
        if (this.getPipelineName() != null) {
            ((SOAPClientContext)parent.getSubcontext(SOAPClientContext.class, true)).setPipelineName(this.getPipelineName());
        }
        if (this.getSecurityConfigurationProfileId() != null) {
            ((SOAPClientSecurityContext)parent.getSubcontext(SOAPClientSecurityContext.class, true)).setSecurityConfigurationProfileId(this.getSecurityConfigurationProfileId());
        }
        if ((selfID = this.getSelfEntityID()) != null) {
            SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)parent.getSubcontext(SAMLSelfEntityContext.class, true);
            selfContext.setEntityId(selfID);
        }
        if ((peerID = this.getPeerEntityID()) == null) {
            this.errorMissingData("Peer entityID");
        }
        if ((peerRoleName = this.getPeerEntityRole()) == null) {
            this.errorMissingData("Peer role");
        }
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)parent.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId(peerID);
        peerContext.setRole(peerRoleName);
        SAMLMetadataContext metadataContext = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class, true);
        metadataContext.setEntityDescriptor(this.getPeerEntityDescriptor());
        metadataContext.setRoleDescriptor(this.getPeerRoleDescriptor());
        return opContext;
    }

    private void errorMissingData(@Nonnull String details) throws MessageException {
        throw new MessageException("Required context data was not supplied or derivable: " + details);
    }

    public static class DefaultTLSCriteriaSetStrategy
    implements Function<MessageContext<?>, CriteriaSet> {
        public CriteriaSet apply(@Nullable MessageContext<?> messageContext) {
            SAMLPeerEntityContext peerContext;
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new UsageCriterion(UsageType.SIGNING));
            if (messageContext == null) {
                return criteria;
            }
            BaseContext parent = new RecursiveTypedParentContextLookup(InOutOperationContext.class).apply(messageContext);
            if (parent == null) {
                return criteria;
            }
            SAMLProtocolContext protocolContext = (SAMLProtocolContext)parent.getSubcontext(SAMLProtocolContext.class);
            if (protocolContext != null && protocolContext.getProtocol() != null) {
                criteria.add((Object)new ProtocolCriterion(protocolContext.getProtocol()));
            }
            if ((peerContext = (SAMLPeerEntityContext)parent.getSubcontext(SAMLPeerEntityContext.class)) != null) {
                SAMLMetadataContext metadataContext;
                if (peerContext.getEntityId() != null) {
                    criteria.add((Object)new EntityIdCriterion(peerContext.getEntityId()));
                }
                if (peerContext.getRole() != null) {
                    criteria.add((Object)new EntityRoleCriterion(peerContext.getRole()));
                }
                if ((metadataContext = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class)) != null && metadataContext.getRoleDescriptor() != null) {
                    criteria.add((Object)new RoleDescriptorCriterion(metadataContext.getRoleDescriptor()));
                }
            }
            return criteria;
        }
    }
}

