/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.http;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipelineFactory;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.http.AbstractPipelineHttpSOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PipelineFactoryHttpSOAPClient<OutboundMessageType, InboundMessageType>
extends AbstractPipelineHttpSOAPClient<OutboundMessageType, InboundMessageType> {
    private Logger log = LoggerFactory.getLogger(PipelineFactoryHttpSOAPClient.class);
    private HttpClientMessagePipelineFactory<InboundMessageType, OutboundMessageType> pipelineFactory;
    private Function<InOutOperationContext<?, ?>, String> pipelineNameStrategy;

    public void setPipelineFactory(@Nonnull HttpClientMessagePipelineFactory<InboundMessageType, OutboundMessageType> factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.pipelineFactory = (HttpClientMessagePipelineFactory)Constraint.isNotNull(factory, (String)"HttpClientPipelineFactory cannot be null");
    }

    public void setPipelineNameStrategy(@Nullable Function<InOutOperationContext<?, ?>, String> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.pipelineNameStrategy = function;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.pipelineFactory == null) {
            throw new ComponentInitializationException("HttpClientPipelineFactory cannot be null");
        }
        if (this.pipelineNameStrategy == null) {
            this.pipelineNameStrategy = new DefaultPipelineNameStrategy();
        }
    }

    @Override
    protected void doDestroy() {
        this.pipelineFactory = null;
        this.pipelineNameStrategy = null;
        super.doDestroy();
    }

    @Override
    @Nonnull
    protected HttpClientMessagePipeline<InboundMessageType, OutboundMessageType> resolvePipeline(InOutOperationContext operationContext) throws SOAPException {
        String resolvedPipelineName = null;
        try {
            resolvedPipelineName = this.resolvePipelineName(operationContext);
            this.log.debug("Resolved pipeline name: {}", (Object)resolvedPipelineName);
            if (resolvedPipelineName != null) {
                return this.newPipeline(resolvedPipelineName);
            }
            return this.newPipeline();
        }
        catch (SOAPException e) {
            this.log.warn("Problem resolving pipeline instance with name: {}", (Object)resolvedPipelineName, (Object)e);
            throw e;
        }
        catch (Exception e) {
            this.log.warn("Problem resolving pipeline instance with name: {}", (Object)resolvedPipelineName, (Object)e);
            throw new SOAPException("Could not resolve pipeline with name: " + resolvedPipelineName, e);
        }
    }

    @Override
    @Nonnull
    protected HttpClientMessagePipeline<InboundMessageType, OutboundMessageType> newPipeline() throws SOAPException {
        return this.pipelineFactory.newInstance();
    }

    @Nullable
    protected HttpClientMessagePipeline<InboundMessageType, OutboundMessageType> newPipeline(@Nullable String name) throws SOAPException {
        return this.pipelineFactory.newInstance(name);
    }

    @Nullable
    protected String resolvePipelineName(@Nonnull InOutOperationContext operationContext) {
        if (this.pipelineNameStrategy != null) {
            return (String)this.pipelineNameStrategy.apply((Object)operationContext);
        }
        return null;
    }

    public static class DefaultPipelineNameStrategy
    implements Function<InOutOperationContext<?, ?>, String> {
        public String apply(@Nullable InOutOperationContext<?, ?> opContext) {
            if (opContext == null) {
                return null;
            }
            SOAPClientContext context = (SOAPClientContext)opContext.getSubcontext(SOAPClientContext.class);
            if (context != null) {
                return context.getPipelineName();
            }
            return null;
        }
    }
}

