/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PahoMQTTTest
extends MQTTTestSupport {
    private static final Logger log = Logger.getLogger(PahoMQTTTest.class);
    public String protocol;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({"tcp"}, {"ws"});
    }

    public PahoMQTTTest(String protocol) {
        this.protocol = protocol;
    }

    @Test(timeout=300000L)
    public void testLotsOfClients() throws Exception {
        final int CLIENTS = Integer.getInteger("PahoMQTTTest.CLIENTS", 100);
        log.debug((Object)("Using: {} clients: " + CLIENTS));
        final AtomicInteger receiveCounter = new AtomicInteger();
        MqttClient client = this.createPahoClient("consumer");
        client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                receiveCounter.incrementAndGet();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        client.connect();
        client.subscribe("test");
        final AtomicReference asyncError = new AtomicReference();
        final CountDownLatch connectedDoneLatch = new CountDownLatch(CLIENTS);
        final CountDownLatch disconnectDoneLatch = new CountDownLatch(CLIENTS);
        final CountDownLatch sendBarrier = new CountDownLatch(1);
        for (int i = 0; i < CLIENTS; ++i) {
            Thread.sleep(10L);
            new Thread(null, null, "client:" + i){

                @Override
                public void run() {
                    try {
                        MqttClient client = PahoMQTTTest.this.createPahoClient(Thread.currentThread().getName());
                        client.connect();
                        connectedDoneLatch.countDown();
                        sendBarrier.await();
                        for (int i = 0; i < 10; ++i) {
                            Thread.sleep(1000L);
                            client.publish("test", "hello".getBytes(), 1, false);
                        }
                        client.disconnect();
                        client.close();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        asyncError.set(e);
                    }
                    finally {
                        disconnectDoneLatch.countDown();
                    }
                }
            }.start();
        }
        connectedDoneLatch.await();
        PahoMQTTTest.assertNull((String)("Async error: " + asyncError.get()), asyncError.get());
        sendBarrier.countDown();
        log.debug((Object)"All clients connected... waiting to receive sent messages...");
        this.within(30, TimeUnit.SECONDS, new MQTTTestSupport.Task(){

            @Override
            public void run() throws Exception {
                Assert.assertTrue((receiveCounter.get() == CLIENTS * 10 ? (byte)1 : 0) != 0);
            }
        });
        log.debug((Object)"All messages received.");
        disconnectDoneLatch.await();
        PahoMQTTTest.assertNull((String)("Async error: " + asyncError.get()), asyncError.get());
    }

    @Test(timeout=300000L)
    public void testSendAndReceiveMQTT() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumerId");
        MqttClient producer = this.createPahoClient("producerId");
        consumer.connect();
        consumer.subscribe("test");
        consumer.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        producer.connect();
        producer.publish("test", "hello".getBytes(), 1, false);
        PahoMQTTTest.waitForLatch((CountDownLatch)latch);
        producer.disconnect();
        producer.close();
    }

    @Test(timeout=300000L)
    public void testSessionPresentWithCleanSession() throws Exception {
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        IMqttToken result = client.connectWithResult(options);
        PahoMQTTTest.assertFalse((boolean)result.getSessionPresent());
        client.disconnect();
    }

    @Test(timeout=300000L)
    public void testSessionPresent() throws Exception {
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        IMqttToken result = client.connectWithResult(options);
        PahoMQTTTest.assertFalse((boolean)result.getSessionPresent());
        client.disconnect();
        result = client.connectWithResult(options);
        PahoMQTTTest.assertTrue((boolean)result.getSessionPresent());
    }

    private MqttClient createPahoClient(String clientId) throws MqttException {
        return new MqttClient(this.protocol + "://localhost:" + this.getPort(), clientId, (MqttClientPersistence)new MemoryPersistence());
    }
}

