/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.management.SecurityNotificationTest;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLSecurityNotificationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession adminSession;
    private ClientConsumer notifConsumer;
    private SimpleString notifQueue;

    @Test
    public void testSECURITY_AUTHENTICATION_VIOLATION() throws Exception {
        SSLSecurityNotificationTest.flush(this.notifConsumer);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "unknown-client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        long start = System.currentTimeMillis();
        try {
            sf.createSession();
            Assert.fail((String)"authentication must fail and a notification of security violation must be sent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientMessage[] notifications = SSLSecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals(null, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER));
        Assert.assertEquals((Object)"CN=ActiveMQ Artemis Unknown Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assert.assertTrue((boolean)notifications[0].getObjectProperty(ManagementHelper.HDR_REMOTE_ADDRESS).toString().startsWith("/127.0.0.1"));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testCONSUMER_CREATED() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        Role role = new Role("notif", true, true, true, true, false, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession guestSession = sf.createSession("guest", "guest", false, true, true, false, 1);
        guestSession.createQueue(new QueueConfiguration(queue).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        SSLSecurityNotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        guestSession.createConsumer(queue);
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.CONSUMER_CREATED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)"guest", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assert.assertEquals((Object)"first", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_VALIDATED_USER).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertEquals((Object)"CN=ActiveMQ Artemis Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        guestSession.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        this.server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        this.server.start();
        this.notifQueue = RandomUtil.randomSimpleString();
        Role role = new Role("notif", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString(), roles);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        this.adminSession = sf.createSession(true, true, 1);
        this.adminSession.start();
        this.adminSession.createQueue(new QueueConfiguration(this.notifQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.notifConsumer = this.adminSession.createConsumer(this.notifQueue);
    }

    private static void flush(ClientConsumer notifConsumer) throws ActiveMQException {
        ClientMessage message = null;
        while ((message = notifConsumer.receive(500L)) != null) {
        }
    }

    protected static ClientMessage[] consumeMessages(int expected, ClientConsumer consumer) throws Exception {
        ClientMessage[] messages = new ClientMessage[expected];
        ClientMessage m = null;
        for (int i = 0; i < expected; ++i) {
            m = consumer.receive(500L);
            Assert.assertNotNull((String)("expected to received " + expected + " messages, got only " + i), (Object)m);
            messages[i] = m;
            m.acknowledge();
        }
        m = consumer.receiveImmediate();
        Assert.assertNull((String)("received one more message than expected (" + expected + ")"), (Object)m);
        return messages;
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

