/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Test;

public class NonExistentQueueTest
extends JMSTestBase {
    @Test
    public void sendToNonExistentDestination() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)));
        Topic destination = ActiveMQJMSClient.createTopic((String)"DoesNotExist");
        TransportConfiguration transportConfiguration = new TransportConfiguration(InVMConnectorFactory.class.getName());
        ActiveMQConnectionFactory localConnectionFactory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
        Connection connection = localConnectionFactory.createConnection();
        Session session = connection.createSession();
        try {
            MessageProducer messageProducer = session.createProducer(null);
            messageProducer.send((Destination)destination, session.createMessage());
            Assert.fail((String)"Succeeded in sending message to a non-existent destination using JMS 1 API!");
        }
        catch (JMSException messageProducer) {
            // empty catch block
        }
        JMSContext context = localConnectionFactory.createContext();
        JMSProducer jmsProducer = context.createProducer().setDeliveryMode(2);
        try {
            jmsProducer.send((Destination)destination, context.createMessage());
            Assert.fail((String)"Succeeded in sending message to a non-existent destination using JMS 2 API!");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }
}

