/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.divert;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class PersistentDivertTest
extends ActiveMQTestBase {
    final int minLargeMessageSize = 204800;

    @Test
    public void testPersistentDivert() throws Exception {
        this.doTestPersistentDivert(false);
    }

    @Test
    public void testPersistentDiverLargeMessage() throws Exception {
        this.doTestPersistentDivert(true);
    }

    public void doTestPersistentDivert(boolean largeMessage) throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true, 0);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1"));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2"));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3"));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress"));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(true);
            if (largeMessage) {
                message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)204800L));
            }
            message.putIntProperty(propKey, i);
            producer.send((Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }

    private void checkLargeMessage(ClientMessage message) {
        for (int j = 0; j < 204800; ++j) {
            Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)j), (long)message.getBodyBuffer().readByte());
        }
    }

    @Test
    public void testPersistentDivertRestartBeforeConsume() throws Exception {
        this.doTestPersistentDivertRestartBeforeConsume(false);
    }

    @Test
    public void testPersistentDivertRestartBeforeConsumeLargeMessage() throws Exception {
        this.doTestPersistentDivertRestartBeforeConsume(true);
    }

    public void doTestPersistentDivertRestartBeforeConsume(boolean largeMessage) throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String forwardAddress1 = "forwardAddress1";
        String forwardAddress2 = "forwardAddress2";
        String forwardAddress3 = "forwardAddress3";
        DivertConfiguration divertConf1 = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress("testAddress").setForwardingAddress("forwardAddress1");
        DivertConfiguration divertConf2 = new DivertConfiguration().setName("divert2").setRoutingName("divert2").setAddress("testAddress").setForwardingAddress("forwardAddress2");
        DivertConfiguration divertConf3 = new DivertConfiguration().setName("divert3").setRoutingName("divert3").setAddress("testAddress").setForwardingAddress("forwardAddress3");
        Configuration config = this.createDefaultInVMConfig().addDivertConfiguration(divertConf1).addDivertConfiguration(divertConf2).addDivertConfiguration(divertConf3);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true, 0);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        session.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress1"));
        session.createQueue(new QueueConfiguration(queueName2).setAddress("forwardAddress2"));
        session.createQueue(new QueueConfiguration(queueName3).setAddress("forwardAddress3"));
        session.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress"));
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(true);
            message2.putIntProperty(propKey, i2);
            if (largeMessage) {
                message2.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)204800L));
            }
            producer.send((Message)message2);
        }
        session.close();
        sf.close();
        server.stop();
        this.waitForServerToStop(server);
        server.start();
        ServerLocator locator2 = this.createInVMNonHALocator().setBlockOnDurableSend(true);
        sf = this.createSessionFactory(locator2);
        session = sf.createSession(false, true, true);
        session.start();
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        ClientConsumer consumer4 = session.createConsumer(queueName4);
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(5000L);
            Assert.assertNotNull((Object)message);
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer2.receive(5000L);
            Assert.assertNotNull((Object)message);
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer3.receive(5000L);
            Assert.assertNotNull((Object)message);
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer3.receiveImmediate());
        for (i = 0; i < 10; ++i) {
            message = consumer4.receive(5000L);
            Assert.assertNotNull((Object)message);
            if (largeMessage) {
                this.checkLargeMessage(message);
            }
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer4.receiveImmediate());
        session.close();
        sf.close();
        server.stop();
        this.waitForServerToStop(server);
        server.start();
        ServerLocator locator3 = this.createInVMNonHALocator().setBlockOnDurableSend(true);
        sf = this.createSessionFactory(locator3);
        session = sf.createSession(false, true, true);
        consumer1 = session.createConsumer(queueName1);
        consumer2 = session.createConsumer(queueName2);
        consumer3 = session.createConsumer(queueName3);
        consumer4 = session.createConsumer(queueName4);
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
        Assert.assertNull((Object)consumer4.receiveImmediate());
    }
}

