/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.reattach;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RandomReattachTest
extends ActiveMQTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    private static final Logger log = Logger.getLogger(RandomReattachTest.class);
    private static final int RECEIVE_TIMEOUT = 10000;
    private static final SimpleString ADDRESS = new SimpleString("FailoverTestAddress");
    private ActiveMQServer server;
    private Timer timer;

    @Test
    public void testA() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestA(sf);
            }
        });
    }

    @Test
    public void testB() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestB(sf);
            }
        });
    }

    @Test
    public void testC() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestC(sf);
            }
        });
    }

    @Test
    public void testD() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestD(sf);
            }
        });
    }

    @Test
    public void testE() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestE(sf);
            }
        });
    }

    @Test
    public void testF() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestF(sf);
            }
        });
    }

    @Test
    public void testG() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestG(sf);
            }
        });
    }

    @Test
    public void testH() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestH(sf);
            }
        });
    }

    @Test
    public void testI() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestI(sf);
            }
        });
    }

    @Test
    public void testJ() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestJ(sf);
            }
        });
    }

    @Test
    public void testK() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestK(sf);
            }
        });
    }

    @Test
    public void testL() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestL(sf);
            }
        });
    }

    @Test
    public void testN() throws Exception {
        this.runTest(new RunnableT(){

            @Override
            public void run(ClientSessionFactory sf) throws Exception {
                RandomReattachTest.this.doTestN(sf);
            }
        });
    }

    public void runTest(RunnableT runnable) throws Exception {
        int numIts = this.getNumIterations();
        for (int its = 0; its < numIts; ++its) {
            log.debug((Object)("####" + this.getName() + " iteration #" + its));
            this.start();
            ServerLocator locator = this.createInVMNonHALocator().setReconnectAttempts(15).setConfirmationWindowSize(0x100000);
            ClientSessionFactory sf = this.createSessionFactory(locator);
            ClientSession session = sf.createSession(false, false, false);
            Failer failer = this.startFailer(1000L, session);
            do {
                runnable.run(sf);
            } while (!failer.isExecuted());
        }
    }

    protected void doTestA(ClientSessionFactory sf) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = new SimpleString("sub" + i);
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.start();
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)message);
        }
        class MyHandler
        extends AssertionCheckMessageHandler {
            final CountDownLatch latch = new CountDownLatch(1);
            int count;

            MyHandler() {
            }

            @Override
            public void onMessageAssert(ClientMessage message) {
                if (this.count == 100) {
                    Assert.fail((String)"Too many messages");
                }
                Assert.assertEquals((Object)this.count, (Object)message.getObjectProperty(new SimpleString("count")));
                ++this.count;
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException me) {
                    log.error((Object)"Failed to process", (Throwable)me);
                }
                if (this.count == 100) {
                    this.latch.countDown();
                }
            }
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(5000L, TimeUnit.MILLISECONDS);
            handler.checkAssertions();
            Assert.assertTrue((String)"Didn't receive all messages", (boolean)ok);
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = new SimpleString("sub" + i);
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    /*
     * WARNING - void declaration
     */
    protected void doTestB(ClientSessionFactory sf) throws Exception {
        void var12_23;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 50;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i = 0; i < 50; ++i) {
            SimpleString subName = new SimpleString("sub" + i);
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)clientMessage);
        }
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        class MyHandler
        extends AssertionCheckMessageHandler {
            final CountDownLatch latch = new CountDownLatch(1);
            int count;

            MyHandler() {
            }

            @Override
            public void onMessageAssert(ClientMessage message) {
                if (this.count == 100) {
                    Assert.fail((String)"Too many messages");
                }
                Assert.assertEquals((Object)this.count, (Object)message.getObjectProperty(new SimpleString("count")));
                ++this.count;
                if (this.count == 100) {
                    this.latch.countDown();
                }
            }
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(10000L, TimeUnit.MILLISECONDS);
            handler.checkAssertions();
            Assert.assertTrue((boolean)ok);
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        boolean bl = false;
        while (var12_23 < 50) {
            SimpleString subName = new SimpleString("sub" + (int)var12_23);
            s.deleteQueue(subName);
            ++var12_23;
        }
        s.close();
        long l = System.currentTimeMillis();
        log.debug((Object)("duration " + (l - start)));
    }

    protected void doTestC(ClientSessionFactory sf) throws Exception {
        Object message;
        int i;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        boolean numSessions = true;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i2 = 0; i2 < 1; ++i2) {
            SimpleString subName = new SimpleString("sub" + i2);
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.start();
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (i = 0; i < 100; ++i) {
            message = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)message);
        }
        sessSend.rollback();
        for (i = 0; i < 100; ++i) {
            message = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)message);
        }
        sessSend.commit();
        class MyHandler
        extends AssertionCheckMessageHandler {
            final CountDownLatch latch = new CountDownLatch(1);
            int count;

            MyHandler() {
            }

            @Override
            public void onMessageAssert(ClientMessage message) {
                if (this.count == 100) {
                    Assert.fail((String)("Too many messages, expected " + this.count));
                }
                Assert.assertEquals((Object)this.count, (Object)message.getObjectProperty(new SimpleString("count")));
                ++this.count;
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (this.count == 100) {
                    this.latch.countDown();
                }
            }
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(10000L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)ok);
            handler.checkAssertions();
        }
        handlers.clear();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (ClientSession session : sessions) {
            session.rollback();
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(10000L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)ok);
            handler.checkAssertions();
        }
        for (ClientSession session : sessions) {
            session.commit();
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i3 = 0; i3 < 1; ++i3) {
            SimpleString subName = new SimpleString("sub" + i3);
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    /*
     * WARNING - void declaration
     */
    protected void doTestD(ClientSessionFactory sf) throws Exception {
        void var12_29;
        int i;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i2 = 0; i2 < 10; ++i2) {
            SimpleString subName = new SimpleString("sub" + i2);
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (i = 0; i < 100; ++i) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)clientMessage);
        }
        sessSend.rollback();
        for (i = 0; i < 100; ++i) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)clientMessage);
        }
        sessSend.commit();
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        class MyHandler
        extends AssertionCheckMessageHandler {
            final CountDownLatch latch = new CountDownLatch(1);
            int count;

            MyHandler() {
            }

            @Override
            public void onMessageAssert(ClientMessage message) {
                if (this.count == 100) {
                    Assert.fail((String)("Too many messages, " + this.count));
                }
                Assert.assertEquals((Object)this.count, (Object)message.getObjectProperty(new SimpleString("count")));
                ++this.count;
                if (this.count == 100) {
                    this.latch.countDown();
                }
            }
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(20000L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)ok);
            handler.checkAssertions();
        }
        handlers.clear();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler();
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (ClientSession session : sessions) {
            session.rollback();
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(10000L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)ok);
            handler.checkAssertions();
        }
        for (ClientSession session : sessions) {
            session.commit();
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        boolean bl = false;
        while (var12_29 < 10) {
            SimpleString subName = new SimpleString("sub" + (int)var12_29);
            s.deleteQueue(subName);
            ++var12_29;
        }
        s.close();
        long l = System.currentTimeMillis();
        log.debug((Object)("duration " + (l - start)));
    }

    protected void doTestE(ClientSessionFactory sf) throws Exception {
        ClientMessage msg;
        int i;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i2 = 0; i2 < 10; ++i2) {
            SimpleString subName = new SimpleString("sub" + i2);
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.start();
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (i = 0; i < 100; ++i) {
            ClientMessage message = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            producer.send((Message)message);
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receiveImmediate();
                Assert.assertNull((Object)msg);
            }
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            SimpleString subName = new SimpleString("sub" + i3);
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    protected void doTestF(ClientSessionFactory sf) throws Exception {
        ClientMessage msg;
        int i;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i2 = 0; i2 < 10; ++i2) {
            SimpleString subName = new SimpleString("sub" + i2);
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (int i3 = 0; i3 < 100; ++i3) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i3);
            producer.send((Message)clientMessage);
        }
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                if (msg == null) {
                    throw new IllegalStateException("Failed to receive message " + i);
                }
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receiveImmediate();
                Assert.assertNull((Object)msg);
            }
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i4 = 0; i4 < 10; ++i4) {
            SimpleString simpleString = new SimpleString("sub" + i4);
            s.deleteQueue(simpleString);
        }
        s.close();
        Assert.assertEquals((long)1L, (long)((ClientSessionFactoryImpl)sf).numSessions());
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    protected void doTestG(ClientSessionFactory sf) throws Exception {
        int i;
        ClientMessage msg;
        int i2;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i3 = 0; i3 < 10; ++i3) {
            SimpleString subName = new SimpleString("sub" + i3);
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.start();
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (int i22 = 0; i22 < 100; ++i22) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i22);
            producer.send((Message)clientMessage);
        }
        sessSend.rollback();
        for (i2 = 0; i2 < 100; ++i2) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i2);
            producer.send((Message)clientMessage);
        }
        sessSend.commit();
        for (i2 = 0; i2 < 100; ++i2) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i2, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (ClientConsumer clientConsumer : consumers) {
            ClientMessage msg2 = clientConsumer.receiveImmediate();
            Assert.assertNull((Object)msg2);
        }
        for (ClientSession clientSession : sessions) {
            clientSession.rollback();
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receiveImmediate();
                Assert.assertNull((Object)msg);
            }
        }
        for (ClientSession clientSession : sessions) {
            clientSession.commit();
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i4 = 0; i4 < 10; ++i4) {
            SimpleString simpleString = new SimpleString("sub" + i4);
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    protected void doTestH(ClientSessionFactory sf) throws Exception {
        int i;
        ClientMessage msg;
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i4 = 0; i4 < 10; ++i4) {
            SimpleString subName = new SimpleString("sub" + i4);
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.createQueue(new QueueConfiguration(subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        for (int i3 = 0; i3 < 100; ++i3) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i3);
            producer.send((Message)clientMessage);
        }
        sessSend.rollback();
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage clientMessage = sessSend.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            clientMessage.putIntProperty(new SimpleString("count"), i2);
            producer.send((Message)clientMessage);
        }
        sessSend.commit();
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i2, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (int i3 = 0; i3 < 100; ++i3) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receiveImmediate();
                Assert.assertNull((Object)msg);
            }
        }
        for (ClientSession clientSession : sessions) {
            clientSession.rollback();
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receive(10000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)i, (Object)msg.getObjectProperty(new SimpleString("count")));
                msg.acknowledge();
            }
        }
        for (i = 0; i < 100; ++i) {
            for (ClientConsumer consumer : consumers) {
                msg = consumer.receiveImmediate();
                Assert.assertNull((Object)msg);
            }
        }
        for (ClientSession clientSession : sessions) {
            clientSession.commit();
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i5 = 0; i5 < 10; ++i5) {
            SimpleString simpleString = new SimpleString("sub" + i5);
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        log.debug((Object)("duration " + (end - start)));
    }

    protected void doTestI(ClientSessionFactory sf) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.createQueue(new QueueConfiguration(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.start();
        ClientConsumer consumer = sess.createConsumer(ADDRESS);
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(10000L);
        Assert.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.close();
        sessCreate.deleteQueue(ADDRESS);
        sessCreate.close();
    }

    protected void doTestJ(ClientSessionFactory sf) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.createQueue(new QueueConfiguration(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.start();
        ClientConsumer consumer = sess.createConsumer(ADDRESS);
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(10000L);
        Assert.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.close();
        sessCreate.deleteQueue(ADDRESS);
        sessCreate.close();
    }

    protected void doTestK(ClientSessionFactory sf) throws Exception {
        ClientSession s = sf.createSession(false, false, false);
        s.createQueue(new QueueConfiguration(ADDRESS).setDurable(Boolean.valueOf(false)));
        int numConsumers = 100;
        for (int i = 0; i < 100; ++i) {
            ClientConsumer consumer = s.createConsumer(ADDRESS);
            consumer.close();
        }
        s.deleteQueue(ADDRESS);
        s.close();
    }

    protected void doTestL(ClientSessionFactory sf) throws Exception {
        int numSessions = 10;
        for (int i = 0; i < 10; ++i) {
            ClientSession session = sf.createSession(false, false, false);
            session.close();
        }
    }

    protected void doTestN(ClientSessionFactory sf) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.createQueue(new QueueConfiguration(new SimpleString(ADDRESS.toString())).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.stop();
        sess.start();
        sess.stop();
        ClientConsumer consumer = sess.createConsumer(new SimpleString(ADDRESS.toString()));
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        sess.start();
        ClientMessage message2 = consumer.receive(10000L);
        Assert.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.stop();
        sess.start();
        sess.close();
        sessCreate.deleteQueue(new SimpleString(ADDRESS.toString()));
        sessCreate.close();
    }

    protected int getNumIterations() {
        return 2;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.timer = new Timer(true);
    }

    @After
    public void tearDown() throws Exception {
        this.timer.cancel();
        super.tearDown();
    }

    private Failer startFailer(long time, ClientSession session) {
        Failer failer = new Failer((ClientSessionInternal)session);
        this.timer.schedule((TimerTask)failer, (long)((double)time * Math.random()), 100L);
        return failer;
    }

    private void start() throws Exception {
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
    }

    private void stop() throws Exception {
        this.server.stop();
        Assert.assertEquals((long)0L, (long)InVMRegistry.instance.size());
        this.server = null;
    }

    static abstract class AssertionCheckMessageHandler
    implements MessageHandler {
        private final ArrayList<AssertionError> errors = new ArrayList();

        AssertionCheckMessageHandler() {
        }

        public void checkAssertions() {
            Iterator<AssertionError> iterator = this.errors.iterator();
            if (iterator.hasNext()) {
                AssertionError e = iterator.next();
                throw e;
            }
        }

        public void onMessage(ClientMessage message) {
            try {
                this.onMessageAssert(message);
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
                this.errors.add(e);
            }
        }

        public abstract void onMessageAssert(ClientMessage var1);
    }

    public abstract class RunnableT {
        abstract void run(ClientSessionFactory var1) throws Exception;
    }

    class Failer
    extends TimerTask {
        private final ClientSessionInternal session;
        private boolean executed;

        Failer(ClientSessionInternal session) {
            this.session = session;
        }

        @Override
        public synchronized void run() {
            log.debug((Object)"** Failing connection");
            this.session.getConnection().fail((ActiveMQException)((Object)new ActiveMQNotConnectedException("oops")));
            log.debug((Object)"** Fail complete");
            this.cancel();
            this.executed = true;
        }

        public synchronized boolean isExecuted() {
            return this.executed;
        }
    }
}

