/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.connectors;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.smallrye.reactive.messaging.providers.helpers.Validation;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import io.vertx.mutiny.core.WorkerExecutor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

@ApplicationScoped
public class WorkerPoolRegistry {
    private static final String WORKER_CONFIG_PREFIX = "smallrye.messaging.worker";
    private static final String WORKER_CONCURRENCY = "max-concurrency";
    @Inject
    private Instance<ExecutionHolder> executionHolder;
    @Inject
    private Instance<Config> configInstance;
    private final Map<String, Integer> workerConcurrency = new HashMap<String, Integer>();
    private final Map<String, WorkerExecutor> workerExecutors = new ConcurrentHashMap<String, WorkerExecutor>();
    private ExecutionHolder holder;

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=100) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (!this.workerExecutors.isEmpty()) {
            for (WorkerExecutor executor : this.workerExecutors.values()) {
                executor.close();
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.executionHolder.isUnsatisfied()) {
            ProviderLogging.log.noExecutionHolderDisablingBlockingSupport();
        } else {
            this.holder = (ExecutionHolder)this.executionHolder.get();
        }
    }

    public <T> Uni<T> executeWork(Uni<T> uni, String workerName, boolean ordered) {
        if (this.holder == null) {
            throw new UnsupportedOperationException("@Blocking disabled");
        }
        Objects.requireNonNull(uni, ProviderMessages.msg.actionNotProvided());
        if (workerName == null) {
            return this.holder.vertx().executeBlocking(uni, ordered);
        }
        return this.getWorker(workerName).executeBlocking(uni, ordered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerExecutor getWorker(String workerName) {
        Objects.requireNonNull(workerName, ProviderMessages.msg.workerNameNotSpecified());
        if (this.workerExecutors.containsKey(workerName)) {
            return this.workerExecutors.get(workerName);
        }
        if (this.workerConcurrency.containsKey(workerName)) {
            WorkerExecutor executor = this.workerExecutors.get(workerName);
            if (executor == null) {
                WorkerPoolRegistry workerPoolRegistry = this;
                synchronized (workerPoolRegistry) {
                    executor = this.workerExecutors.get(workerName);
                    if (executor == null) {
                        executor = this.holder.vertx().createSharedWorkerExecutor(workerName, this.workerConcurrency.get(workerName).intValue());
                        ProviderLogging.log.workerPoolCreated(workerName, this.workerConcurrency.get(workerName));
                        this.workerExecutors.put(workerName, executor);
                    }
                }
            }
            if (executor != null) {
                return executor;
            }
            throw ProviderExceptions.ex.runtimeForFailedWorker(workerName);
        }
        throw ProviderExceptions.ex.illegalArgumentForFailedWorker();
    }

    public <T> void analyzeWorker(AnnotatedType<T> annotatedType) {
        Objects.requireNonNull(annotatedType, ProviderMessages.msg.annotatedTypeWasEmpty());
        Set methods = annotatedType.getMethods();
        methods.stream().filter(m -> m.isAnnotationPresent(Blocking.class)).forEach(m -> this.defineWorker(m.getJavaMember()));
    }

    public void defineWorker(String className, String method, String poolName) {
        Objects.requireNonNull(className, ProviderMessages.msg.classNameWasEmpty());
        Objects.requireNonNull(method, ProviderMessages.msg.methodWasEmpty());
        if (!poolName.equals("<no-value>")) {
            if (Validation.isBlank(poolName)) {
                throw ProviderExceptions.ex.illegalArgumentForAnnotationNullOrBlank("@Blocking", className + "#" + method);
            }
            String workerConfigKey = "smallrye.messaging.worker." + poolName + "." + WORKER_CONCURRENCY;
            Optional concurrency = ((Config)this.configInstance.get()).getOptionalValue(workerConfigKey, Integer.class);
            if (!concurrency.isPresent()) {
                throw ProviderExceptions.ex.illegalArgumentForWorkerConfigKey("@Blocking", className + "#" + method, workerConfigKey);
            }
            this.workerConcurrency.put(poolName, (Integer)concurrency.get());
        }
    }

    private void defineWorker(Method method) {
        Objects.requireNonNull(method, ProviderMessages.msg.methodWasEmpty());
        Blocking blocking = method.getAnnotation(Blocking.class);
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        if (!method.isAnnotationPresent(Incoming.class) && !method.isAnnotationPresent(Outgoing.class)) {
            throw ProviderExceptions.ex.illegalBlockingSignature(className + "#" + method);
        }
        this.defineWorker(className, methodName, blocking.value());
    }
}

