/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import io.smallrye.metrics.MetricsRequestHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;

public class MetricsContextService
implements Service {
    private static final String CONTEXT_NAME = "/metrics";
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private final boolean securityEnabled;
    private final MetricsRequestHandler metricsRequestHandler;

    static void install(OperationContext context, boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.HTTP_CONTEXT_SERVICE);
        Supplier extensibleHttpManagement = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class));
        MetricsContextService healthContextService = new MetricsContextService(extensibleHttpManagement, securityEnabled, new MetricsRequestHandler());
        serviceBuilder.setInstance((Service)healthContextService).install();
    }

    MetricsContextService(Supplier<ExtensibleHttpManagement> extensibleHttpManagement, boolean securityEnabled, MetricsRequestHandler metricsRequestHandler) {
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.securityEnabled = securityEnabled;
        this.metricsRequestHandler = metricsRequestHandler;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT_NAME, this.securityEnabled, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String requestPath = exchange.getRequestPath();
                String method = exchange.getRequestMethod().toString();
                HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
                MetricsContextService.this.metricsRequestHandler.handleRequest(requestPath, method, acceptHeaders == null ? null : acceptHeaders.stream(), (status, message, headers) -> {
                    exchange.setStatusCode(status);
                    StringBuffer buffer = new StringBuffer();
                    for (Map.Entry entry : headers.entrySet()) {
                        exchange.getResponseHeaders().put(new HttpString((String)entry.getKey()), (String)entry.getValue());
                    }
                    buffer.append(message);
                    if (status / 100 == 2 && (exchange.getRequestPath().equals(MetricsContextService.CONTEXT_NAME) || exchange.getRequestPath().equals("/metrics/"))) {
                        boolean jsonOutput;
                        String acceptHeader = exchange.getRequestHeaders().getFirst(Headers.ACCEPT);
                        boolean bl = jsonOutput = acceptHeader != null && acceptHeader.startsWith("application/json");
                        if (!jsonOutput) {
                            try (StringWriter sw = new StringWriter();){
                                CollectorRegistry registry = CollectorRegistry.defaultRegistry;
                                TextFormat.write004((Writer)sw, (Enumeration)registry.metricFamilySamples());
                                buffer.append(sw.toString());
                            }
                        }
                    }
                    exchange.getResponseSender().send(buffer.toString());
                });
            }
        });
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT_NAME);
    }
}

