package org.wildfly.extension.microprofile.metrics._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.StartException;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-30T14:59:52-0800")
public class MicroProfileMetricsLogger_$logger extends DelegatingBasicLogger implements MicroProfileMetricsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MicroProfileMetricsLogger_$logger.class.getName();
    public MicroProfileMetricsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    private static final String activatingSubsystem = "WFLYMETRICS0001: Activating Eclipse MicroProfile Metrics Subsystem";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    private static final String failedInitializeJMXRegistrar = "WFLYMETRICS0002: Failed to initialize metrics from JMX MBeans";
    protected String failedInitializeJMXRegistrar$str() {
        return failedInitializeJMXRegistrar;
    }
    @Override
    public final StartException failedInitializeJMXRegistrar(final IOException e) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedInitializeJMXRegistrar$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReadAttribute = "WFLYMETRICS0003: Unable to read attribute %s on %s: %s.";
    protected String unableToReadAttribute$str() {
        return unableToReadAttribute;
    }
    @Override
    public final IllegalStateException unableToReadAttribute(final String attributeName, final PathAddress address, final String error) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToReadAttribute$str(), attributeName, address, error));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConvertAttribute = "WFLYMETRICS0004: Unable to convert attribute %s on %s to Double value.";
    protected String unableToConvertAttribute$str() {
        return unableToConvertAttribute;
    }
    @Override
    public final IllegalStateException unableToConvertAttribute(final String attributeName, final PathAddress address, final Exception exception) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToConvertAttribute$str(), attributeName, address), exception);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedMetric = "WFLYMETRICS0005: Metric attribute %s on %s is undefined and will not be exposed.";
    protected String undefinedMetric$str() {
        return undefinedMetric;
    }
    @Override
    public final IllegalStateException undefinedMetric(final String attributeName, final PathAddress address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), undefinedMetric$str(), attributeName, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
