/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContextException;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.Map;
import org.jboss.as.ee.security.JaccService;
import org.jboss.as.ejb3.security.EjbJaccConfig;
import org.jboss.as.server.deployment.AttachmentList;
import org.wildfly.common.Assert;
import org.wildfly.security.jakarta.authz.PolicyRegistration;

public class EjbJaccService
extends JaccService<AttachmentList<EjbJaccConfig>> {
    private final ClassLoader deploymentClassLoader;

    public EjbJaccService(String contextId, AttachmentList<EjbJaccConfig> metaData, Boolean standalone, ClassLoader deploymClassLoader) {
        super(contextId, metaData, standalone);
        this.deploymentClassLoader = (ClassLoader)Assert.checkNotNullParam((String)"deploymentClassLoader", (Object)deploymClassLoader);
    }

    public void createPermissions(AttachmentList<EjbJaccConfig> metaData, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (EjbJaccConfig permission : metaData) {
            for (Permission deny : permission.getDeny()) {
                policyConfiguration.addToExcludedPolicy(deny);
            }
            for (Permission permit : permission.getPermit()) {
                policyConfiguration.addToUncheckedPolicy(permit);
            }
            for (Map.Entry role : permission.getRoles()) {
                policyConfiguration.addToRole((String)role.getKey(), (Permission)role.getValue());
            }
        }
    }

    public void beginContextPolicy() throws GeneralSecurityException {
        PolicyRegistration.beginContextPolicy((String)this.contextId, (ClassLoader)this.deploymentClassLoader);
    }

    public void endContextPolicy() throws GeneralSecurityException {
        PolicyRegistration.endContextPolicy((String)this.contextId);
    }
}

