/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import jakarta.ejb.TimerConfig;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.ejb3.timerservice.TimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.Functions;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class TimerServiceFactoryServiceInstaller
implements DeploymentServiceInstaller {
    private final ServiceName name;
    private final ManagedTimerServiceFactoryConfiguration configuration;
    private final String threadPoolName;
    private final String store;
    private final Predicate<TimerConfig> filter;

    public TimerServiceFactoryServiceInstaller(ServiceName name, ManagedTimerServiceFactoryConfiguration configuration, Predicate<TimerConfig> filter, String threadPoolName, String store) {
        this.name = name;
        this.configuration = configuration;
        this.filter = filter;
        this.threadPoolName = threadPoolName;
        this.store = store;
    }

    public void install(DeploymentPhaseContext context) {
        final ServiceDependency executor = ServiceDependency.on(EJB3SubsystemRootResourceDefinition.EXECUTOR_SERVICE_DESCRIPTOR, (String)this.threadPoolName);
        final ServiceDependency persistence = this.store != null ? ServiceDependency.on(TimerPersistence.SERVICE_DESCRIPTOR, (String)this.store) : ServiceDependency.of(null);
        final ServiceDependency timer = ServiceDependency.on(TimerServiceResourceDefinition.TIMER_SERVICE_DESCRIPTOR);
        final TimedObjectInvokerFactory invokerFactory = this.configuration.getInvokerFactory();
        final TimerServiceRegistry registry = this.configuration.getTimerServiceRegistry();
        final TimerListener listener = this.configuration.getTimerListener();
        final Predicate<TimerConfig> filter = this.filter;
        ManagedTimerServiceFactory factory = new ManagedTimerServiceFactory(){

            @Override
            public ManagedTimerService createTimerService(EJBComponent component) {
                final TimedObjectInvoker invoker = invokerFactory.createInvoker(component);
                return new TimerServiceImpl(new TimerServiceConfiguration(){

                    @Override
                    public TimedObjectInvoker getInvoker() {
                        return invoker;
                    }

                    @Override
                    public TimerServiceRegistry getTimerServiceRegistry() {
                        return registry;
                    }

                    @Override
                    public TimerListener getTimerListener() {
                        return listener;
                    }

                    @Override
                    public Executor getExecutor() {
                        return (Executor)executor.get();
                    }

                    @Override
                    public Timer getTimer() {
                        return (Timer)timer.get();
                    }

                    @Override
                    public TimerPersistence getTimerPersistence() {
                        return (TimerPersistence)persistence.get();
                    }

                    @Override
                    public Predicate<TimerConfig> getTimerFilter() {
                        return filter;
                    }
                });
            }
        };
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)Functions.constantSupplier((Object)factory)).provides(this.name)).requires(List.of(executor, persistence, timer))).build()).install(context);
    }
}

