/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import jakarta.ejb.EJBException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimerTask;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;

public class CalendarTimer
extends TimerImpl {
    private final CalendarBasedTimeout calendarTimeout;
    private final boolean autoTimer;
    private final Method timeoutMethod;

    public CalendarTimer(Builder builder, TimerServiceImpl timerService) {
        super(builder, timerService);
        Calendar nextTimeout;
        this.autoTimer = builder.autoTimer;
        if (this.autoTimer) {
            assert (builder.timeoutMethod != null);
            this.timeoutMethod = builder.timeoutMethod;
        } else {
            assert (builder.timeoutMethod == null);
            this.timeoutMethod = null;
        }
        this.calendarTimeout = new CalendarBasedTimeout(builder.scheduleExpression);
        if (builder.nextDate == null && builder.newTimer && (nextTimeout = this.calendarTimeout.getNextTimeout()) != null) {
            this.nextExpiration = nextTimeout.getTime();
        }
    }

    @Override
    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.calendarTimeout.getScheduleExpression();
    }

    public ScheduleExpression getScheduleExpression() {
        return this.calendarTimeout.getScheduleExpression();
    }

    @Override
    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return true;
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        return this.calendarTimeout;
    }

    @Override
    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    @Override
    protected CalendarTimerTask getTimerTask() {
        return new CalendarTimerTask(this);
    }

    public Method getTimeoutMethod() {
        if (!this.autoTimer) {
            throw EjbLogger.EJB3_TIMER_LOGGER.failToInvokegetTimeoutMethod();
        }
        return this.timeoutMethod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void handleRestorationCalculation() {
        if (this.nextExpiration == null) {
            return;
        }
        if (this.nextExpiration.getTime() >= System.currentTimeMillis()) {
            return;
        }
        this.nextExpiration = new Date(System.currentTimeMillis() - 1L);
    }

    public static Method getTimeoutMethod(TimeoutMethod timeoutMethodInfo, ClassLoader classLoader) {
        if (timeoutMethodInfo == null) {
            return null;
        }
        try {
            Class<?> timeoutMethodDeclaringClass = Class.forName(timeoutMethodInfo.getDeclaringClass(), false, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw EjbLogger.EJB3_TIMER_LOGGER.failToLoadDeclaringClassOfTimeOut(timeoutMethodInfo.getDeclaringClass());
        }
        String timeoutMethodName = timeoutMethodInfo.getMethodName();
        for (Class<?> klass = timeoutMethodDeclaringClass; klass != null; klass = klass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = klass.getDeclaredMethods()) {
                if (!method.getName().equals(timeoutMethodName) || !(timeoutMethodInfo.hasTimerParameter() ? method.getParameterCount() == 1 && method.getParameterTypes()[0] == Timer.class : method.getParameterCount() == 0)) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getScheduleExpression();
    }

    public static class Builder
    extends TimerImpl.Builder {
        private ScheduleExpression scheduleExpression;
        private boolean autoTimer;
        private Method timeoutMethod;

        public Builder setScheduleExpression(ScheduleExpression scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public Builder setAutoTimer(boolean autoTimer) {
            this.autoTimer = autoTimer;
            return this;
        }

        public Builder setTimeoutMethod(Method timeoutMethod) {
            this.timeoutMethod = timeoutMethod;
            return this;
        }

        @Override
        public CalendarTimer build(TimerServiceImpl timerService) {
            return new CalendarTimer(this, timerService);
        }
    }
}

