/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11;

import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.wsc11.FaultOrResponse;
import java.util.HashMap;
import java.util.Map;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterResponseType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class AsynchronousRegistrationMapper {
    private static final AsynchronousRegistrationMapper mapper = new AsynchronousRegistrationMapper();
    private Map<String, FaultOrResponse> responses = new HashMap<String, FaultOrResponse>();

    public static AsynchronousRegistrationMapper getInstance() {
        return mapper;
    }

    public void addClientMessage(String messageId) {
        WSCLogger.logger.tracev("AsynchronousRegistrationMapper addClientMessage {0}", (Object)messageId);
        this.responses.put(messageId, new FaultOrResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaultOrResponse waitForResponse(String messageId, long millis) {
        FaultOrResponse res = this.responses.get(messageId);
        if (res == null) {
            throw new IllegalStateException("The messageId " + messageId + " is not waiting for response");
        }
        FaultOrResponse faultOrResponse = res;
        synchronized (faultOrResponse) {
            if (res.isEmpty()) {
                try {
                    WSCLogger.logger.tracev("AsynchronousRegistrationMapper waitForResponse {0} {1}", (Object)messageId, (Object)millis);
                    res.wait(millis);
                }
                catch (InterruptedException e) {
                    WSCLogger.logger.warnv("AsynchronousRegistrationMapper waitForResponse: being interrupted and this should not happen!", new Object[0]);
                }
            }
            this.responses.remove(messageId);
        }
        WSCLogger.logger.tracev("AsynchronousRegistrationMapper addClientMessage returning isResponse={0} isFault={1}", (Object)res.isResponse(), (Object)res.isFault());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignResponse(String messageId, RegisterResponseType response) {
        FaultOrResponse res = this.responses.get(messageId);
        if (res == null) {
            throw new IllegalStateException("The messageId " + messageId + " is not waiting for response");
        }
        FaultOrResponse faultOrResponse = res;
        synchronized (faultOrResponse) {
            res.setResponse(response);
            WSCLogger.logger.tracev("AsynchronousRegistrationMapper assignResponse {0}", (Object)messageId);
            res.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignFault(String messageId, Fault fault) {
        FaultOrResponse res = this.responses.get(messageId);
        if (res == null) {
            throw new IllegalStateException("The messageId " + messageId + " is not waiting for response");
        }
        FaultOrResponse faultOrResponse = res;
        synchronized (faultOrResponse) {
            res.setFault(fault);
            WSCLogger.logger.tracev("AsynchronousRegistrationMapper assignFault {0}", (Object)messageId);
            res.notifyAll();
        }
    }

    public int size() {
        return this.responses.size();
    }
}

