/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;

final class CLIPrintStream
extends PrintStream {
    private static final ThreadLocal<Boolean> entered = new ThreadLocal();
    private final PrintStream baseDelegate;
    private volatile PrintStream delegate;

    CLIPrintStream() {
        super(new ByteArrayOutputStream(), true);
        this.delegate = this.baseDelegate = System.out;
    }

    CLIPrintStream(OutputStream consoleOutput) {
        super(new ByteArrayOutputStream(), true);
        assert (consoleOutput != null);
        this.delegate = this.baseDelegate = new PrintStream(consoleOutput);
    }

    void captureOutput(PrintStream delegate) {
        if (this.delegate != this.baseDelegate) {
            throw new IllegalStateException("Output is already being captured");
        }
        this.delegate.flush();
        this.delegate = delegate == null ? this.baseDelegate : delegate;
    }

    void releaseOutput() {
        if (this.delegate == this.baseDelegate) {
            throw new IllegalStateException("Output is not being captured");
        }
        this.delegate.flush();
        this.delegate = this.baseDelegate;
    }

    @Override
    public void flush() {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.flush();
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void close() {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.close();
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public boolean checkError() {
        if (entered.get() != null) {
            return false;
        }
        try {
            entered.set(Boolean.TRUE);
            boolean bl = this.delegate.checkError();
            return bl;
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void write(int b) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.write(b);
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.write(buf, off, len);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(boolean b) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(b);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(char c) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(c);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(int i) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(i);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(long l) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(l);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(float f) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(f);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(double d) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(d);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(char[] s) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(s);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(String s) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(s);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void print(Object obj) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.print(obj);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println() {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println();
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(boolean x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(char x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(int x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(long x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(float x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(double x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(char[] x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(String x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public void println(Object x) {
        if (entered.get() != null) {
            return;
        }
        try {
            entered.set(Boolean.TRUE);
            this.delegate.println(x);
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream printf(String format, Object ... args) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.printf(format, args);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.printf(l, format, args);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(String format, Object ... args) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.format(format, args);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.format(l, format, args);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.append(csq);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.append(csq, start, end);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }

    @Override
    public PrintStream append(char c) {
        if (entered.get() != null) {
            return this;
        }
        try {
            entered.set(Boolean.TRUE);
            PrintStream printStream = this.delegate.append(c);
            return printStream;
        }
        finally {
            entered.remove();
        }
    }
}

