/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators;

import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsFactoryResolver;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ReactiveStreams {
    private ReactiveStreams() {
    }

    public static <T> PublisherBuilder<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveStreamsFactoryResolver.instance().fromPublisher(publisher);
    }

    public static <T> PublisherBuilder<T> of(T t) {
        return ReactiveStreamsFactoryResolver.instance().of(t);
    }

    public static <T> PublisherBuilder<T> of(T ... ts) {
        return ReactiveStreamsFactoryResolver.instance().of(ts);
    }

    public static <T> PublisherBuilder<T> empty() {
        return ReactiveStreamsFactoryResolver.instance().empty();
    }

    public static <T> PublisherBuilder<T> ofNullable(T t) {
        return ReactiveStreamsFactoryResolver.instance().ofNullable(t);
    }

    public static <T> PublisherBuilder<T> fromIterable(Iterable<? extends T> ts) {
        return ReactiveStreamsFactoryResolver.instance().fromIterable(ts);
    }

    public static <T> PublisherBuilder<T> failed(Throwable t) {
        return ReactiveStreamsFactoryResolver.instance().failed(t);
    }

    public static <T> ProcessorBuilder<T, T> builder() {
        return ReactiveStreamsFactoryResolver.instance().builder();
    }

    public static <T, R> ProcessorBuilder<T, R> fromProcessor(Processor<? super T, ? extends R> processor) {
        return ReactiveStreamsFactoryResolver.instance().fromProcessor(processor);
    }

    public static <T> SubscriberBuilder<T, Void> fromSubscriber(Subscriber<? extends T> subscriber) {
        return ReactiveStreamsFactoryResolver.instance().fromSubscriber(subscriber);
    }

    public static <T> PublisherBuilder<T> iterate(T seed, UnaryOperator<T> f) {
        return ReactiveStreamsFactoryResolver.instance().iterate(seed, f);
    }

    public static <T> PublisherBuilder<T> generate(Supplier<? extends T> s) {
        return ReactiveStreamsFactoryResolver.instance().generate(s);
    }

    public static <T> PublisherBuilder<T> concat(PublisherBuilder<? extends T> a, PublisherBuilder<? extends T> b) {
        return ReactiveStreamsFactoryResolver.instance().concat(a, b);
    }

    public static <T> PublisherBuilder<T> fromCompletionStage(CompletionStage<? extends T> completionStage) {
        return ReactiveStreamsFactoryResolver.instance().fromCompletionStage(completionStage);
    }

    public static <T> PublisherBuilder<T> fromCompletionStageNullable(CompletionStage<? extends T> completionStage) {
        return ReactiveStreamsFactoryResolver.instance().fromCompletionStageNullable(completionStage);
    }

    public static <T, R> ProcessorBuilder<T, R> coupled(SubscriberBuilder<? super T, ?> subscriber, PublisherBuilder<? extends R> publisher) {
        return ReactiveStreamsFactoryResolver.instance().coupled(subscriber, publisher);
    }

    public static <T, R> ProcessorBuilder<T, R> coupled(Subscriber<? super T> subscriber, Publisher<? extends R> publisher) {
        return ReactiveStreamsFactoryResolver.instance().coupled(subscriber, publisher);
    }
}

