/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;

public class SubnetMatchInterfaceCriteria
extends AbstractInterfaceCriteria {
    private static final long serialVersionUID = 149404752878332750L;
    private byte[] network;
    private int mask;

    public SubnetMatchInterfaceCriteria(byte[] network, int mask) {
        if (network == null) {
            throw ControllerMessages.MESSAGES.nullVar("network");
        }
        this.network = network;
        this.mask = mask;
    }

    @Override
    protected InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        byte[] addr = address.getAddress();
        if (addr.length != this.network.length) {
            return null;
        }
        int last = addr.length - this.mask;
        for (int i = 0; i < last; ++i) {
            if (addr[i] == this.network[i]) continue;
            return null;
        }
        return address;
    }

    public int hashCode() {
        int i = 17;
        i = 31 * i + this.mask;
        i = 31 * i + Arrays.hashCode(this.network);
        return i;
    }

    public boolean equals(Object o) {
        return o instanceof SubnetMatchInterfaceCriteria && Arrays.equals(this.network, ((SubnetMatchInterfaceCriteria)o).network) && this.mask == ((SubnetMatchInterfaceCriteria)o).mask;
    }
}

