/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import org.jboss.as.ee.concurrent.resource.definition.ManagedExecutorDefinitionInjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionAnnotationProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public class ManagedExecutorDefinitionAnnotationProcessor
extends ResourceDefinitionAnnotationProcessor {
    private static final DotName MANAGED_EXECUTOR_DEFINITION = DotName.createSimple((String)ManagedExecutorDefinition.class.getName());
    private static final DotName MANAGED_EXECUTOR_DEFINITION_LIST = DotName.createSimple((String)ManagedExecutorDefinition.List.class.getName());

    protected DotName getAnnotationDotName() {
        return MANAGED_EXECUTOR_DEFINITION;
    }

    protected DotName getAnnotationCollectionDotName() {
        return MANAGED_EXECUTOR_DEFINITION_LIST;
    }

    protected ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        String jndiName = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"name");
        String context = ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"context");
        String hungTaskThresholdString = ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"hungTaskThreshold");
        long hungTaskThreshold = hungTaskThresholdString != null && !hungTaskThresholdString.isEmpty() ? Math.max(Long.valueOf(hungTaskThresholdString), 0L) : 0L;
        int maxAsync = ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalInt((AnnotationInstance)annotationInstance, (String)"maxAsync");
        ManagedExecutorDefinitionInjectionSource injectionSource = new ManagedExecutorDefinitionInjectionSource(jndiName);
        injectionSource.setContextServiceRef(context);
        injectionSource.setHungTaskThreshold(hungTaskThreshold);
        injectionSource.setMaxAsync(maxAsync);
        return injectionSource;
    }
}

