/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SpecificationProvider;

public enum UndertowSpecificationProvider implements SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener>
{
    INSTANCE;


    public HttpSession createHttpSession(final ImmutableSession session, final ServletContext context) {
        return new HttpSession(){

            public String getId() {
                return session.getId();
            }

            public ServletContext getServletContext() {
                return context;
            }

            public boolean isNew() {
                return session.getMetaData().isNew();
            }

            public long getCreationTime() {
                return session.getMetaData().getCreationTime().toEpochMilli();
            }

            public long getLastAccessedTime() {
                return session.getMetaData().getLastAccessedTime().toEpochMilli();
            }

            public int getMaxInactiveInterval() {
                return (int)session.getMetaData().getMaxInactiveInterval().getSeconds();
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(session.getAttributes().getAttributeNames());
            }

            public Object getAttribute(String name) {
                return session.getAttributes().getAttribute(name);
            }

            public void setAttribute(String name, Object value) {
            }

            public void removeAttribute(String name) {
            }

            public void invalidate() {
            }

            public void setMaxInactiveInterval(int interval) {
            }

            @Deprecated
            public String[] getValueNames() {
                return Collections.list(this.getAttributeNames()).toArray(new String[0]);
            }

            @Deprecated
            public Object getValue(String name) {
                return this.getAttribute(name);
            }

            @Deprecated
            public void putValue(String name, Object value) {
                this.setAttribute(name, value);
            }

            @Deprecated
            public void removeValue(String name) {
                this.removeAttribute(name);
            }

            @Deprecated
            public HttpSessionContext getSessionContext() {
                return new HttpSessionContext(){

                    public Enumeration<String> getIds() {
                        return Collections.enumeration(Collections.emptyList());
                    }

                    public HttpSession getSession(String sessionId) {
                        return null;
                    }
                };
            }
        };
    }

    public Class<HttpSessionActivationListener> getHttpSessionActivationListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> prePassivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionWillPassivate(new HttpSessionEvent(session));
            }
        };
    }

    public Consumer<HttpSession> postActivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionDidActivate(new HttpSessionEvent(session));
            }
        };
    }

    public HttpSessionActivationListener createListener(final Consumer<HttpSession> prePassivate, final Consumer<HttpSession> postActivate) {
        return new HttpSessionActivationListener(){

            public void sessionWillPassivate(HttpSessionEvent event) {
                prePassivate.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postActivate.accept(event.getSession());
            }
        };
    }
}

