/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.EvictableDataContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactoryServiceConfigurator<C extends Marshallability, L>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanSessionManagerFactoryConfiguration<C, L>,
Supplier<SessionManagerFactory<L, TransactionBatch>> {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final SessionManagerFactoryConfiguration<C, L> configuration;
    private final String containerName;
    private final CapabilityServiceConfigurator configurationConfigurator;
    private final CapabilityServiceConfigurator cacheConfigurator;
    private volatile SupplierDependency<NodeFactory<Address>> group;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile Supplier<Cache> cache;

    public InfinispanSessionManagerFactoryServiceConfigurator(SessionManagerFactoryConfiguration<C, L> configuration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", DEFAULT_CACHE_CONTAINER, configuration.getDeploymentName()}));
        this.configuration = configuration;
        ServiceName baseServiceName = ServiceName.JBOSS.append(new String[]{"infinispan"});
        String configCacheName = this.configuration.getCacheName();
        ServiceName configServiceName = ServiceName.parse((String)(configCacheName != null ? configCacheName : DEFAULT_CACHE_CONTAINER));
        if (!baseServiceName.isParentOf(configServiceName)) {
            configServiceName = baseServiceName.append(configServiceName);
        }
        this.containerName = (configServiceName.length() > 3 ? configServiceName.getParent() : configServiceName).getSimpleName();
        String templateCacheName = configServiceName.length() > 3 ? configServiceName.getSimpleName() : null;
        String cacheName = this.configuration.getDeploymentName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            int size;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanWebLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, templateCacheName));
            }
            EvictionStrategy strategy = (size = configuration.getMaxActiveSessions()) > 0 ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().evictionStrategy(strategy).evictionType(EvictionType.COUNT).storageType(StorageType.OBJECT).size((long)size);
            if (strategy.isEnabled()) {
                builder.dataContainer().dataContainer(EvictableDataContainer.createDataContainer((ConfigurationBuilder)builder, (long)size, SessionCreationMetaDataKey.class::isInstance));
            }
        };
        this.configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, cacheName)), this.containerName, cacheName, templateCacheName, configurator);
        this.cacheConfigurator = new CacheServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(this.containerName, cacheName)), this.containerName, cacheName);
    }

    @Override
    public SessionManagerFactory<L, TransactionBatch> get() {
        return new InfinispanSessionManagerFactory(this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurationConfigurator.configure(support);
        this.cacheConfigurator.configure(support);
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, this.containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.configuration.getServerName()));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurationConfigurator.build(target).install();
        this.cacheConfigurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.group, this.affinityFactory, this.dispatcherFactory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        this.cache = builder.requires(this.cacheConfigurator.getServiceName());
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public SessionManagerFactoryConfiguration<C, L> getSessionManagerFactoryConfiguration() {
        return this.configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.group.get();
    }
}

