/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.staxmapper.Versioned;
import org.wildfly.extension.clustering.web.DistributableWebResourceDefinition;
import org.wildfly.extension.clustering.web.DistributableWebSubsystemSchema;
import org.wildfly.extension.clustering.web.HotRodSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.LocalRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.NoAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.PrimaryOwnerAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.RankedAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;

public enum DistributableWebXMLDescriptionFactory implements Function<DistributableWebSubsystemSchema, PersistentResourceXMLDescription>
{
    INSTANCE;


    @Override
    public PersistentResourceXMLDescription apply(DistributableWebSubsystemSchema schema) {
        return PersistentResourceXMLDescription.builder((PathElement)DistributableWebResourceDefinition.PATH, schema.getNamespace()).addAttributes(Attribute.stream(DistributableWebResourceDefinition.Attribute.class)).addChild(DistributableWebXMLDescriptionFactory.getInfinispanSessionManagementResourceXMLBuilder(schema)).addChild(DistributableWebXMLDescriptionFactory.getHotRodSessionManagementResourceXMLBuilder(schema)).addChild(PersistentResourceXMLDescription.builder((PathElement)InfinispanSSOManagementResourceDefinition.WILDCARD_PATH).addAttributes(Attribute.stream(InfinispanSSOManagementResourceDefinition.Attribute.class))).addChild(PersistentResourceXMLDescription.builder((PathElement)HotRodSSOManagementResourceDefinition.WILDCARD_PATH).addAttributes(Attribute.stream(HotRodSSOManagementResourceDefinition.Attribute.class))).addChild(PersistentResourceXMLDescription.builder((PathElement)LocalRoutingProviderResourceDefinition.PATH).setXmlElementName("local-routing")).addChild(PersistentResourceXMLDescription.builder((PathElement)InfinispanRoutingProviderResourceDefinition.PATH).addAttributes(Attribute.stream(InfinispanRoutingProviderResourceDefinition.Attribute.class)).setXmlElementName("infinispan-routing")).build();
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder getInfinispanSessionManagementResourceXMLBuilder(DistributableWebSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)InfinispanSessionManagementResourceDefinition.WILDCARD_PATH).addAttributes(Stream.concat(Attribute.stream(InfinispanSessionManagementResourceDefinition.Attribute.class), Attribute.stream(SessionManagementResourceDefinition.Attribute.class)));
        DistributableWebXMLDescriptionFactory.addAffinityChildren(builder).addChild(PersistentResourceXMLDescription.builder((PathElement)PrimaryOwnerAffinityResourceDefinition.PATH).setXmlElementName("primary-owner-affinity"));
        if (schema.since((Versioned)DistributableWebSubsystemSchema.VERSION_2_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)RankedAffinityResourceDefinition.PATH).addAttributes(Attribute.stream(RankedAffinityResourceDefinition.Attribute.class)).setXmlElementName("ranked-affinity"));
        }
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder getHotRodSessionManagementResourceXMLBuilder(DistributableWebSubsystemSchema schema) {
        return DistributableWebXMLDescriptionFactory.addAffinityChildren(PersistentResourceXMLDescription.builder((PathElement)HotRodSessionManagementResourceDefinition.WILDCARD_PATH).addAttributes(Stream.concat(Attribute.stream(HotRodSessionManagementResourceDefinition.Attribute.class), Attribute.stream(SessionManagementResourceDefinition.Attribute.class))));
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder addAffinityChildren(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        return builder.addChild(PersistentResourceXMLDescription.builder((PathElement)NoAffinityResourceDefinition.PATH).setXmlElementName("no-affinity")).addChild(PersistentResourceXMLDescription.builder((PathElement)LocalAffinityResourceDefinition.PATH).setXmlElementName("local-affinity"));
    }
}

